package com.ella.util;

import com.ella.util.redis.RedisServiceUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * @author: wqq
 * @Date: 2021/7/7 15:29
 * @Description:
 * @Modified:
 */
public class VerifyCheckCodeFailUtil {
    /**
     * 校验验证码是否通过 true:验证码通过，false：验证码错误
     *
     * @param redis
     * @param phone
     * @param code
     * @return
     */
    public static boolean checkCodeIsError(RedisServiceUtil redis, String phone, String code) {
        //默认验证码
        String defaultCode = "0000";
        //判断验证码，若是默认校验手机号是否在默认密码白名单
        if (defaultCode.equals(code)) {
            String loginWhitelistKey = "SUNRISE:LOGIN:MOBILE:WHITELIST:";
            String loginWhitelist = redis.get(loginWhitelistKey);
            boolean isWhitelist = StringUtils.isNotBlank(loginWhitelist) && loginWhitelist.indexOf(phone) >= 0;
            if (isWhitelist) {
                return true;
            }
        }
        return false;
    }
}
