package com.ella.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.ss.formula.functions.T;
import org.hibernate.validator.HibernateValidator;

import javax.validation.Validation;
import javax.validation.Validator;
import java.math.BigDecimal;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by mengxiangchao on 2017/11/22.
 */
public class VeriFyUtil {
    /**
     * 验证是否合法手机号：是否为11位纯数字且以13、14、15、17、18开头
     *
     * @param num
     * @return
     */
    public static boolean checkIsMobileNum(String num) {
        return StringUtils.isNotBlank(num)
                && 11 == num.length()
                && num.matches("^[1][3,4,5,6,7,8,9][0-9]{9}$");
    }

    /**
     *
     * @param num
     * @param regularExpressions
     * @return true 合法  false 非法
     */
    public static boolean checkAllIsMobileNum(String num,String regularExpressions) {
        return StringUtils.isNoneBlank(num, regularExpressions)
                && num.matches(regularExpressions);
    }
}
