package com.ella.util;

import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: wqq
 * @Date: 2021/4/20 14:31
 * @Description:
 * @Modified:
 */
public class UrlUtil {
    private static final String UTF_8 = "UTF-8";
    /**
     * 将URL中的参数转化为map
     *
     * @param url
     * @return
     */
    public static Map<String, Object> getUrlParams(String url) {
        Map<String, Object> map = new HashMap<>(0);
        if (StringUtils.isBlank(url)) {
            return map;
        }
        String[] split = url.split("\\?");
        if (split.length > 1) {
            String[] params = split[1].split("&");
            for (int i = 0; i < params.length; i++) {
                String[] p = params[i].split("=");
                if (p.length == 2) {
                    map.put(p[0], p[1]);
                }
            }
        }
        return map;
    }

    public static String getFileName(String url) {
        if (StringUtils.isBlank(url)) {
            return "";
        }
        String urlWithoutParameter = url.split("\\?")[0];
        return urlWithoutParameter.substring(urlWithoutParameter.lastIndexOf("/") + 1, urlWithoutParameter.length());
    }

    public static String getUrlWithoutParameter(String url) {
        if (StringUtils.isBlank(url)) {
            return "";
        }
        return url.split("\\?")[0];
    }

    public static String getFileNameSuffix(String url) {
        String[] split = getFileName(url).split("\\.");
        return split.length > 1 ? split[1] : "";
    }

    public static String getFileNameWithoutSuffix(String url) {
        String fileName = getFileName(url);
        return fileName.split("\\.")[0];
    }

    /**
     * URL编码
     *
     * @param content
     * @return
     */
    public static String urlEncode(String content) {
        try {
            if (StringUtils.isNotBlank(content)) {
                String result = URLEncoder.encode(content, UTF_8);
                return result;
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return content;
    }

    /**
     * URL解码
     *
     * @param content
     * @return
     */
    public static String urlDecode(String content) {
        try {
            if (StringUtils.isNotBlank(content)) {
                String result = URLDecoder.decode(content, UTF_8);
                return result;
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return content;
    }
}
