package com.ella.util;


import com.ella.entity.dto.ResponsePageResultDto;
import com.github.pagehelper.Page;

import java.util.List;

/**
 * @author Administrator
 */
public class ResponsePageResultUtils {

    public static <T extends List> ResponsePageResultDto<T> build(T resultList) {
        ResponsePageResultDto<T> result = new ResponsePageResultDto<T>();
        if (resultList == null) {
            return new ResponsePageResultDto<T>();
        }
        if (resultList instanceof Page) {
            Page<T> page = (Page<T>) resultList;
            result.setPageNum(page.getPageNum());
            result.setPageSize(page.getPageSize());
            result.setTotal(page.getTotal());
            result.setTotalPage(page.getPages());
            result.setList(resultList);
        }

        return result;
    }

    /**
     * @param resultList   PageHelper 返回的分页结果集
     * @param responseList 接口返回的分页结果
     */
    public static <T extends List> ResponsePageResultDto<T> build(List resultList, T responseList) {
        ResponsePageResultDto<T> result = new ResponsePageResultDto<T>();
        if (resultList == null) {
            return new ResponsePageResultDto<T>();
        }
        if (resultList instanceof Page) {
            Page<T> page = (Page<T>) resultList;
            result.setPageNum(page.getPageNum());
            result.setPageSize(page.getPageSize());
            result.setTotal(page.getTotal());
            result.setTotalPage(page.getPages());
            result.setList(responseList);
        }
        return result;
    }

}
