package com.ella.util;

import com.ella.response.ResponseParams;
import org.apache.commons.lang3.StringUtils;

/**
 * 参数检查工具，个人建议使用此工具，而不是ExceptionMsgUtil
 * @Author mengyang
 */
public class ResponseMsgUtil {

    /**
     * 参数不能为空
     *
     * @param str     被检查参数
     * @param msgCode 为空时返回错误码
     * @param msg     为空时返回错误信息
     * @param resp    包含错误信息的response对象
     * @return 参数校验合格返回原responseParam对象，否则返回携带错误信息的responseParam对象
     */
    public static ResponseParams requireNotBlank(ResponseParams<?> resp, String msgCode, String msg, String... str) {
        if (null == str || str.length <= 0) {
            resp.fillError(msg, msgCode);
            return resp;
        }
        for (String i : str) {
            if (StringUtils.isBlank(i)) {
                resp.fillError(msg, msgCode);
                break;
            }
        }
        return resp;
    }

    public static ResponseParams requireNotBlank(String msgCode, String msg, String str) {
        return requireNotBlank(new ResponseParams<>(), msgCode, msg, str);
    }

    public static ResponseParams requireNotBlank(String msg, String str) {
        return requireNotBlank(new ResponseParams<>(), null, msg, str);
    }

    public static ResponseParams requireTrue(boolean check, String msgCode, String msg, ResponseParams<?> resp) {
        if (!check) {
            resp.fillError(msg, msgCode);
        }
        return resp;
    }
}
