package com.ella.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

/**
 * @author ：xixiaoyi
 * @date ：Created by 2021/11/18
 * @modified By：
 */
public class PinYinUtils {
    public static String hanYuPinyinString(String ChineseCharacter) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        //拼音大写
        format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        //不带声调
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        //要转换的中文，格式，转换之后的拼音的分隔符，遇到不能转换的是否保留   wo,shi,zhong,guo,ren,，hello
        String pinyin = null;
        try {
            pinyin = PinyinHelper.toHanYuPinyinString(ChineseCharacter, format, "", false);
        } catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            badHanyuPinyinOutputFormatCombination.printStackTrace();
        }
        return pinyin;
    }

    public static void main(String[] args) {
        System.out.println(hanYuPinyinString("科学探测"));
    }

}
