package com.ella.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.io.Serializable;

/**
 * Created by mengxiangchao on 2017/11/22.
 */
public class JsonUtil {
    /**
     * 将对象中的日期按照（yyyy-MM-dd HH:mm:ss）格式化
     *
     * @param obj
     * @return 返回值类型为JSONObject
     */
    public static JSONObject dateFormat(Object obj) {
        String s = JSONObject.toJSONStringWithDateFormat(obj, JSONObject.DEFFAULT_DATE_FORMAT, SerializerFeature.WriteMapNullValue);
        return JSONObject.parseObject(s);
    }

    /**
     * 将对象中的日期按照（yyyy-MM-dd HH:mm:ss）格式化
     *
     * @param obj
     * @return 返回值类型为JSONArray
     */
    public static JSONArray dateFormatArray(Object obj) {
        String s = JSONObject.toJSONStringWithDateFormat(obj, JSONObject.DEFFAULT_DATE_FORMAT, SerializerFeature.WriteMapNullValue);
        return JSONObject.parseArray(s);
    }

    /**
     * 格式化输出json
     *
     * @param json
     */
    public static String output(Object json) {
        String start = "  ";
        String jsonStr = JSONObject.toJSONString(json,SerializerFeature.WriteMapNullValue);// 先将json对象转化为string对象
        int level = 0;// 用户标记层级
        StringBuffer jsonResultStr = new StringBuffer();// 新建stringbuffer对象，用户接收转化好的string字符串
        for (int i = 0; i < jsonStr.length(); i++) {// 循环遍历每一个字符
            char piece = jsonStr.charAt(i);// 获取当前字符
            // 如果上一个字符是断行，则在本行开始按照level数值添加标记符，排除第一行
            if (i != 0 && '\n' == jsonResultStr.charAt(jsonResultStr.length() - 1)) {
                for (int k = 0; k < level; k++) {
                    jsonResultStr.append(start);
                }
            }
            switch (piece) {
                case '{':
                case '[':
                    // 如果字符是{或者[，则断行，level加1
                    jsonResultStr.append(piece + "\n");
                    level++;
                    break;
                case ',':
                    // 如果是“,”，则断行
                    jsonResultStr.append(piece + "\n");
                    break;
                case '}':
                case ']':
                    // 如果是}或者]，则断行，level减1
                    jsonResultStr.append("\n");
                    level--;
                    for (int k = 0; k < level; k++) {
                        jsonResultStr.append(start);
                    }
                    jsonResultStr.append(piece);
                    break;
                default:
                    jsonResultStr.append(piece);
                    break;
            }
        }
//        System.out.println(jsonResultStr);
        return jsonResultStr.toString();
    }
}
