package com.ella.util;

import org.apache.commons.lang3.StringUtils;

/**
 * 字符串处理工具类集合，根据业务所需，扩展自org.apache.commons.lang3.StringUtils
 * 
 * @author maofengHan
 *
 */
public class ElStringUtils extends StringUtils {
	public static String getBlankIfNull(String s) {
		return s == null ? EMPTY : s;
	}

	/**
	 * 添加Sql Like 查询时的左右%
	 * <p>
	 * 注意：如果s为null或blank，则直接返回空白字符串''
	 * </p>
	 * 
	 * @param s
	 * @return
	 */
	public static String addSqlLikeCondation(String s) {
		return isBlank(s) ? EMPTY : ("%" + s + "%");
	}
	
	public static String addSqlLikeCondationRight(String s) {
		return isBlank(s) ? EMPTY : (s + "%");
	}
}
