package com.ella.util;

import org.apache.commons.lang3.StringUtils;
import org.dom4j.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mengxiangchao on 2018/1/12.
 */
public class Dom4jUtil {

    /**
     * 递归当前根节点将指定类型节点添加到节点列表
     *
     * @param rootNode
     * @param appointElementName
     */
    private void getNodes(List<Element> elementList, Element rootNode, String appointElementName) {
        if (null == rootNode || StringUtils.isBlank(appointElementName)) {
            return;
        }
        if (appointElementName.equals(rootNode.getName())) {
            elementList.add(rootNode);
        }
        rootNode.elements().iterator().forEachRemaining(element -> {
            getNodes(elementList,(Element) element, appointElementName);
        });
    }

    /**
     * 解析xml获取指定类型节点列表
     *
     * @param xml
     * @param appointElementName
     * @return
     * @throws DocumentException
     */
    public List<Element> getAppointElementList(String xml, String appointElementName) throws DocumentException {
        List<Element> elementList = new ArrayList<>();
        if (StringUtils.isBlank(xml) || StringUtils.isBlank(appointElementName)) {
            return elementList;
        }
        Document document = DocumentHelper.parseText("<root>" + xml + "</root>");
        Element rootElement = document.getRootElement();
        this.getNodes(elementList,rootElement, appointElementName);
        return elementList;
    }

    /**
     * 解析xml获取指定类型节点的指定属性值列表
     *
     * @param xml
     * @param appointElementName
     * @param appointAttributeName
     * @return
     * @throws DocumentException
     */
    public List<String> getAppointAttributeValueList(String xml, String appointElementName, String appointAttributeName) throws DocumentException {
        ArrayList<String> valueList = new ArrayList<>();
        if (StringUtils.isBlank(xml) || StringUtils.isBlank(appointElementName) || StringUtils.isBlank(appointAttributeName)) {
            return valueList;
        }
        List<Element> appointElementList = this.getAppointElementList(xml, appointElementName);
        appointElementList.iterator().forEachRemaining(el -> {
            el.attributes().iterator().forEachRemaining(attr -> {
                Attribute attribute = (Attribute) attr;
                if (attribute.getName().equals(appointAttributeName)) {
                    valueList.add(attribute.getValue());
                }
            });
        });
        return valueList;
    }

    public static Dom4jUtil getInstance() {
        return new Dom4jUtil();
    }

    public static void main(String[] args) throws DocumentException {
        String str = "<p style='text-align: center;'><img src='http://member.ellabook.cn/e4bba94583e640db9bf0acc71079b13d'/></p><p style='text-align: center;'>这是例子<br/></p><p style='text-align: center;'><img src='http://member.ellabook.cn/8417fcebe9444ad8b985f4d3248f6e5c '/><img src='http://member.ellabook.cn/25489c63e5b643a18070b9ae52883d13'/></p><p style='text-align: center;'>这又是例子</p>";
        Dom4jUtil dom4jUtil = new Dom4jUtil();
        List<String> imgList = dom4jUtil.getAppointAttributeValueList(str, "img", "src");
        List<String> audioList = dom4jUtil.getAppointAttributeValueList(str, "audio", "src");
        System.out.println(imgList);
        System.out.println(audioList);

    }
}