package com.ella.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Lists;

public class DateUtil {

    public static String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static String DEFAULT_BEGIN_TIME = " 00:00:00";
    public static String DEFAULT_END_TIME = " 23:59:59";


    /**
     * 日期转换成字符串
     */
    public static String dateToString(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    /**
     * 日期转换成字符串
     */
    public static String dateToString(Date date) {
        return dateToString(date, DEFAULT_FORMAT);
    }

    /**
     * 字符串转换成日期
     */
    public static Date stringToDate(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        } catch (ParseException e) {
            return null;
        }
    }

    /**
     * 字符串转换成日期
     */
    public static Date stringToDate(String date) {
        return stringToDate(date, DEFAULT_FORMAT);
    }

    public static Integer leftTime(Date date) {
        Long beginTimes = dateConvert(new Date(), DEFAULT_BEGIN_TIME);
        Long endTimes = dateConvert(date, DEFAULT_END_TIME);
        Long leftTime = (endTimes - beginTimes) / 1000 / 60 / 60; //剩余小时数

        if (leftTime % 24 == 0) {
            leftTime = leftTime / 24;
        } else {
            leftTime = leftTime / 24 + 1;
        }
        return Integer.valueOf(String.valueOf(leftTime));
    }

    /**
     * 日期处理
     *
     * @return
     */
    public static Long dateConvert(Date date, String endTime) {
        String dateStr = dateToString(date, DEFAULT_DATE_FORMAT) + endTime;
        Date nowDate = stringToDate(dateStr);
        System.out.println(dateStr);
        System.out.println(nowDate.getTime());
        return nowDate.getTime();
    }

    /**
     * 当天最后一秒
     *
     * @return
     */
    public static Date todayLastTime() {
        DateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT);
        LocalDate today = LocalDate.now();
        Date dat = new Date();

        String dateStr = today + DEFAULT_END_TIME;
        Date nowDate = null;
        try {
            nowDate = sdf.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return nowDate;
    }


    /**
     * 计算系统日期与目标日期的相隔天数
     *
     * @param tar 与系统时间对比的目标日期
     * @return 相隔天数, 参数无效返回-1
     * author:
     */
    public static int getIntervalDay(Date tar) {
        int ret = -1;
        Calendar calNow = Calendar.getInstance();
        if (null != tar
                && tar.before(calNow.getTime())) {//参数有效

            //获得指定时间的Calendar
            Calendar calTar = Calendar.getInstance();
            calTar.setTime(tar);

            long millisNow = calNow.getTimeInMillis();
            long millisTar = tar.getTime();

            //指定时间小于系统时间才处理， 否则返回-1
            if (millisTar < millisNow) {
                //86400000 = 24*60*60*1000;
                ret = (int) ((millisNow - millisTar) / (86400000));
            }
        }
        return ret;
    }

    public static String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH, -1);

        return format.format(calendar.getTime());
    }

    public static String getLastMonth(String month) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(month));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.add(Calendar.MONTH, -1);

        return format.format(calendar.getTime());
    }

    /**
     * 获取指定日期的前一天
     *
     * @param data
     * @return
     */
    public static Date getLastDay(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        calendar.add(Calendar.DAY_OF_YEAR, -1);
        return calendar.getTime();
    }

    public static String getTodayDateStr() {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return format.format(new Date());
    }

    public static String getNextDay(String day, int n) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_FORMAT);

        Calendar calendar = Calendar.getInstance();//获取日历实例
        try {
            calendar.setTime(sdf.parse(day));
            calendar.add(Calendar.DAY_OF_MONTH, n);  //设置为后n天
        } catch (ParseException e) {
            e.printStackTrace();
        }
        String tomorrow = sdf.format(calendar.getTime());//获得后n天
        return tomorrow;
    }

    /**
     * 获取本周的第一天和最后一天
     *
     * @param data 时间
     * @return 结果
     */
    public static Date[] getFirstAndLastOfWeek(Date data) {
        Date[] dates = new Date[2];
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        int d = 0;
        if (cal.get(Calendar.DAY_OF_WEEK) == 1) {
            d = -6;
        } else {
            d = 2 - cal.get(Calendar.DAY_OF_WEEK);
        }
        cal.add(Calendar.DAY_OF_WEEK, d);
        // 所在周开始日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        SimpleDateFormat sdf2 = new SimpleDateFormat(DEFAULT_FORMAT);
        String dateS = sdf.format(cal.getTime());
        try {
            dates[0] = sdf.parse(dateS);
            cal.add(Calendar.DAY_OF_WEEK, 6);
            dateS = sdf1.format(cal.getTime());
            // 所在周结束日期
            dates[1] = sdf2.parse(dateS);
        } catch (ParseException e) {
        }
        return dates;

    }

    /**
     * 获取某月份的最后一天
     *
     * @param date 日期
     * @return 最后一天
     */
    public static Date getLastdayOfMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        SimpleDateFormat sdf1 = new SimpleDateFormat(DEFAULT_FORMAT);
        Calendar ca = Calendar.getInstance();
        try {
            ca.setTime(date);
            ca.set(Calendar.DAY_OF_MONTH, 1);
            ca.add(Calendar.MONTH, 1);
            ca.add(Calendar.DAY_OF_MONTH, -1);
            String dateS = sdf.format(ca.getTime());
            return sdf1.parse(dateS);
        } catch (ParseException e) {
            return ca.getTime();
        }
    }

    /**
     * 获取某月份的第一天
     *
     * @param date 日期
     * @return 第一天
     */
    public static Date getFirstdayOfMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(Calendar.DAY_OF_MONTH, 1);
        try {
            String dateS = sdf.format(ca.getTime());
            return sdf.parse(dateS);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return ca.getTime();
    }

    /**
     * 获取某月份下一个月的第一天
     *
     * @param date 日期
     * @return 第一天
     */
    public static Date getFirstdayOfNextMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(Calendar.DAY_OF_MONTH, 1);
        ca.add(Calendar.MONTH, 1);
        try {
            String dateS = sdf.format(ca.getTime());
            return sdf.parse(dateS);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return ca.getTime();
    }

    /**
     * 返回两个日期相差的天数
     *
     * @param before 时间1
     * @param after  时间2
     * @return 相差的天数（正数）
     */
    public static long daysBetweenNew(Date before, Date after) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(before);
        long time1 = cal.getTimeInMillis();
        cal.setTime(after);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / (1000 * 3600 * 24);
        return Math.abs(between_days);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        String dateString1 = dateToString(date1, "yyyy-MM-dd");
        String dateString2 = dateToString(date2, "yyyy-MM-dd");
        if (StringUtils.equalsIgnoreCase(dateString1, dateString2)) {
            return true;
        }
        return false;
    }


    public static Date plusDay(int num, Date newDate) {
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(newDate);
            ca.add(Calendar.DATE, num);// num为增加的天数，可以改变的
            newDate = ca.getTime();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return null;
        }
        return newDate;
    }

    /**
     * 获取字符串年
     * 例："2018"
     *
     * @return
     */
    public static String getYearString() {
        Date date = new Date();
        SimpleDateFormat yyyy = new SimpleDateFormat("yyyy");
        String format = yyyy.format(date);
        return format;
    }


    private static boolean isThisTime(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String param = sdf.format(date);//参数时间
        String now = sdf.format(new Date());//当前时间
        if (param.equals(now)) {
            return true;
        }
        return false;
    }

    /**
     * 判断
     * 本月返回本月,其他月返回  本月  1月 2月 ....
     * 其他返回年带月 2017年12月
     *
     * @param date
     * @return
     */
    public static String dateToMonth(Date date) {
        if (isNow(date)){
            return "今天";
        }
        boolean thisTime = isThisTime(date, "yyyy-MM");
        //本月
        if (thisTime) {
            return "本月";
        } else {
            boolean yyyy = isThisTime(date, "yyyy");
            if (yyyy) {//本年
                String s = getDataMonth(date);
                return s + "月";
            }
            String dataYear = getDataYear(date);
            SimpleDateFormat sdf=new SimpleDateFormat("MM");
            String format = sdf.format(date);
            return dataYear + "年" + format + "月";
        }

    }
    private static boolean isNow(Date date) {
        //当前时间
        Date now = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        //获取今天的日期
        String nowDay = sf.format(now);
        //对比的时间
        String day = sf.format(date);
        return day.equals(nowDay);
    }
    public static String dateFormat(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }
    
    public static String dateFormatyyyyMMdd(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }

    public static String dateFormatStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return format.format(date);
    }

    public static Date getDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            return format.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date perseDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return format.parse(format.format(date));
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String addCalendarStr(String startTimeStr, Integer feild, Integer amount) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date endTime = null;

        try {
            Date startTime = format.parse(startTimeStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            calendar.add(feild, amount);
            endTime = calendar.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return format.format(endTime);
    }

    public static String formatConvert(String dateStr, String formatStr, String format2Str) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        SimpleDateFormat format2 = new SimpleDateFormat(format2Str);
        Date date = null;
        try {
            date = format.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return format2.format(date);
    }

    public static Integer getDaysOfDatesStr(String startDate, String endDate, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        Integer days = 0;

        try {
            Date start = format.parse(startDate);
            Date end = format.parse(endDate);
            days = (int) ((end.getTime() - start.getTime()) / (1000 * 60 * 60 * 24));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }


    public static String getNextDay(String date, Integer subDay) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(format.parse(date));
            c.add(Calendar.DAY_OF_MONTH, subDay);// 今天+1天
            Date tomorrow = c.getTime();
//            System.out.println("明天是:" + format.format(tomorrow));
            return format.format(tomorrow);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getNextDayWithYYYYMMDD(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(format.parse(date));
            c.add(Calendar.DAY_OF_MONTH, 1);// 今天+1天
            Date tomorrow = c.getTime();
//            System.out.println("明天是:" + format.format(tomorrow));
            return format.format(tomorrow);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 中英文星期转换
     *
     * @param i
     * @return
     */
    public static int getCNDayOfWeek(int i) {
        HashMap<Integer, Integer> map = new HashMap<>();
        map.put(1, 7);
        map.put(2, 1);
        map.put(3, 2);
        map.put(4, 3);
        map.put(5, 4);
        map.put(6, 5);
        map.put(7, 6);
        return map.get(i);
    }

    public static String getDataYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.YEAR) + "";
    }

    public static String getDataMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return (c.get(Calendar.MONTH) + 1) + "";
    }

    public static String getDataDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.DAY_OF_MONTH) + "";
    }

    public static String getDateHour(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.HOUR_OF_DAY) + "";
    }

    public static long getLongOfEarlierDate(Date start, Date end) {
        if (start.getTime() > end.getTime()) {
            return end.getTime();
        }
        return start.getTime();
    }

    public static long getLongOfLaterDate(Date start, Date end) {
        if (start.getTime() < end.getTime()) {
            return end.getTime();
        }
        return start.getTime();
    }

    public static Date getFisrtDayOfMonth(int year,int month)
    {
        Calendar cal = Calendar.getInstance();
        //设置年份
        cal.set(Calendar.YEAR,year);
        //设置月份
        cal.set(Calendar.MONTH, month-1);
        //获取某月最小天数
        int firstDay = cal.getActualMinimum(Calendar.DAY_OF_MONTH);
        //设置日历中月份的最小天数
        cal.set(Calendar.DAY_OF_MONTH, firstDay);
        return cal.getTime();
    }

    /**
     * data 转换
     *
     * @param datetime
     * @return 2018-05-09 周三
     */
    public static String dateToWeek(Date datetime) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date date = new java.util.Date();
        String str = f.format(datetime);
        String[] weekDays = {"周日", "周一", "周二", "周三", "周四", "周五", "周六"};
        // 获得一个日历
        Calendar cal = Calendar.getInstance();
        Date datet = null;
        try {
            datet = f.parse(str);
            cal.setTime(datet);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //// 指示一个星期中的某天。
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0) {
            w = 0;
        }
        return str + " " + weekDays[w];
    }

    public static String weekOfDay(Date datetime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(datetime);
        String[] weekDays = {"日", "一", "二", "三", "四", "五", "六"};
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    /**
     * 将目标日期的时间设置为：23:59:59
     *
     * @param date
     * @return
     */
    public static Date getDayEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DATE), 23, 59, 59);
        return calendar.getTime();
    }

    /**
     * 将目标日期的时间设置为：00:00:00
     *
     * @param date
     * @return
     */
    public static Date getDayStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DATE), 0, 0, 0);
        return calendar.getTime();
    }

    /**
     * 将目标日期的时间设置为：00:00:00.000
     *
     * @param date
     * @return
     */
    public static Date getDayStartTimeForMilliSecond(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.CHINA);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(gregorianCalendar.get(Calendar.YEAR), gregorianCalendar.get(Calendar.MONTH), gregorianCalendar.get(Calendar.DATE), 0, 0, 0);
        gregorianCalendar.set(Calendar.MILLISECOND, 0);
        return gregorianCalendar.getTime();
    }

    /**
     * 获取指定时间的前一天零点，和当天零点
     *
     * @param date 指定时间
     * @return List 角标0为前一天0点时间数据， 角标1为当天0点时间数据
     */
    public static List<Date> getPreAndCurrentZeroOClock(Date date) {
        List<Date> dateResult = Lists.newArrayList(null, null);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        dateResult.set(1, calendar.getTime());
        calendar.add(Calendar.DAY_OF_YEAR, -1);
        dateResult.set(0, calendar.getTime());
        return dateResult;
    }

    /**
     * 判断当前时间是否在[startTime, endTime]区间，注意时间格式要一致
     *
     * @param nowTime   当前时间
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return
     * @author jqlin
     */
    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime()
                || nowTime.getTime() == endTime.getTime()) {
            return true;
        }

        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);

        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);

        Calendar end = Calendar.getInstance();
        end.setTime(endTime);

        if (date.after(begin) && date.before(end)) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isDiffMonth(String date1, String date2) {
        return isDiffMonth(stringToDate(date1, DEFAULT_DATE_FORMAT), stringToDate(date2, DEFAULT_DATE_FORMAT));
    }

    public static boolean isDiffMonth(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar1.get(Calendar.YEAR) == calendar2.get(Calendar.YEAR)
                && calendar1.get(Calendar.MONTH) == calendar2.get(Calendar.MONTH);
    }

    public static Integer getDifMonth(String startDate, String endDate){
        return getDifMonth(stringToDate(startDate, DEFAULT_DATE_FORMAT), stringToDate(endDate, DEFAULT_DATE_FORMAT));
    }

    public static Integer getDifMonth(Date startDate, Date endDate){
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        int result = end.get(Calendar.MONTH) - start.get(Calendar.MONTH);
        int month = (end.get(Calendar.YEAR) - start.get(Calendar.YEAR)) * 12;
        return Math.abs(month + result);
    }

    public static String dateFormatOfMMdd(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("MM月dd日");
        return format.format(date);
    }


    public static String getScheduleActiveDate(Date scheduleTimeBegin, Integer count){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date today = scheduleTimeBegin;
        Date tomorrow = null;
        int delay = 1;
        int num = count;//根据需要设置,这个值就是业务需要的n个工作日
        while(delay <= num){
            tomorrow = getTomorrow(today);
            //当前日期+1即tomorrow,判断是否是周末,不是则将日期+1,直到循环num次即可
            if(!isWeekend(tomorrow)){
                delay++;
                today = tomorrow;
            } else if (isWeekend(tomorrow)){
                today = tomorrow;
            }
        }
        return sdf.format(today);
    }

    /**
     * 获取明天的日期
     *
     * @param date
     * @return
     */
    public static Date getTomorrow(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, +1);
        date = calendar.getTime();
        return date;
    }


    /**
     * 判断是否是weekend
     *
     * @param sdate
     * @return
     * @throws
     */
    public static boolean isWeekend(Date sdate){
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdate);
        if(cal.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY || cal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY){
            return true;
        } else{
            return false;
        }

    }
    
    /**
     * 日期字符串比较
     * */
    public static int compareDateStr(String dateStr1,String dateStr2){
    	Date date1 = stringToDate(dateStr1,"yyyyMMdd");
    	Date date2 = stringToDate(dateStr2,"yyyyMMdd");
    	
    	return date1.compareTo(date2);
    }
    
    /**
     * 日期字符串比较
     * */
    public static boolean isDateStrBetweenStartAndEndDate(String dateStr,String startDate,String endDate){
    	Date date = stringToDate(dateStr,"yyyyMMdd");
    	Date date1 = stringToDate(startDate,"yyyyMMdd");
    	Date date2 = stringToDate(endDate,"yyyyMMdd");
    	return date.compareTo(date1) >= 0 && date.compareTo(date2) <= 0;
    }
    
    /**
     * 获取指定日期当天开始时间(00:00:00)
     * */
    public static Date getBeginTimeOfDate(Date date) {
        Long beginTimes = dateConvert(date, DEFAULT_BEGIN_TIME);
        return new Date(beginTimes);
    }
    
    /**
     * 获取指定日期当天开始时间(23:59:59)
     * */
    public static Date getEndTimeOfDate(Date date) {
        Long beginTimes = dateConvert(date, DEFAULT_END_TIME);
        return new Date(beginTimes);
    }
    
    /**
     * 是否超过指定天数
     * */
    public static boolean isGreaterThanDayOfDatePeriod(String startDate,String endDate,int day){
    	Date date  = stringToDate(startDate,"yyyyMMdd");
    	Date date1 = stringToDate(endDate,"yyyyMMdd");
    	Calendar cal1 = new GregorianCalendar();
    	cal1.setTime(date);
    	cal1.add(Calendar.DAY_OF_MONTH, day);
    	Calendar cal2 = new GregorianCalendar();
    	cal2.setTime(date1);
    	if(cal2.compareTo(cal1) == 1){
    		return true;
    	}
    	return false;
    }
    
    public static String dateFormatyyyyMM(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(date);
    }

    /**
     * 两个日期之间相差天数 负数表示开始时间在结束时间之后
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getDayBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        Integer dayNum = 0;
        try {
            if (StringUtils.isNotBlank(startDate) && StringUtils.isNotBlank(endDate)) {
                Date start = format.parse(startDate);
                Date end = format.parse(endDate);
                dayNum = (int) ((end.getTime() - start.getTime()) / (1000 * 60 * 60 * 24));
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return dayNum;
    }

    /**
     * 起止日期间隔在day之内，且大于0
     * @param startDate 必须为yyyy-MM-dd格式
     * @param endDate
     * @param day
     * @return
     */
    public static boolean requireTwoDateInANum(String startDate,String endDate,int day){
        return getDayBetweenNum(startDate, endDate) >= 0 && getDayBetweenNum(startDate, endDate) <= day;
    }

    /**
     * 获取指定天数之后date，时间为这一天的0点
     * @param date
     * @param days
     * @return
     */
    public static Date getDateAfterDays(Date date, long days) {
        Calendar calendar = Calendar.getInstance();
        long time = date.getTime();
        calendar.setTimeInMillis(time + days * 1000 * 60 * 60 * 24);
        return getBeginTimeOfDate(calendar.getTime());
    }
    /**
     * 获取指秒后date
     * @param date
     * @param seconds
     * @return
     */
    public static Date getDateAfterSeconds(Date date, long seconds) {
        Calendar calendar = Calendar.getInstance();
        long time = date.getTime();
        calendar.setTimeInMillis(time + seconds * 1000);
        return calendar.getTime();
    }

    /**
     * @return 获取到今天时间结束剩余时长（秒）
     */
    public static long getTimeToTodayEnd() {
        Calendar calendar = Calendar.getInstance();
        long now = calendar.getTimeInMillis();
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DATE), 23, 59, 59);
        long end = calendar.getTimeInMillis();
        return (end - now) / 1000;
    }
}
