package com.ella.util;

public interface BookRedisConstantUtil {


    String REDIS_BOOK_CODE = "BOOK:CODE:";   //图书
    String REDIS_PRESS_CODE = "PRESS:CODE:";//出版社
    String REDIS_BOOK_DETAILS = "BOOK:DETAILS:";//图书详情
    String REDIS_BOOK_ORIGINAUTHOR_NAMES = "BOOK:ORIGINAUTHOR:NAMES:";//图书原作者名字
    String REDIS_BOOK_PREVIEW_RESOURCE = "BOOK:RESOURCE:PREVIEW:";//图书预览资源
    String REDIS_BOOK_COVER_RESOURCE = "BOOK:RESOURCE:COVER:";//图书封面资源
    String REDIS_BOOK_FORMAL_RESOURCE = "BOOK:RESOURCE:FORMAL:";//图书阅读资源
    String REDIS_BOOK_TEACHING_MODE_RESOURCE = "BOOK:RESOURCE:TEACHING:";//图书阅读资源
    String REDIS_BOOK_LISTEN_RESOURCE = "BOOK:RESOURCE:TEACHING:";//图书阅读资源


    String REDIS_INDEX_SUBJECT = "INDEX:SUBJECT:BOE:";//首页专题
    String REDIS_INDEX_PART_1_0_0 = "INDEX:PART:BOE:";//首页栏目,目前没有版本号，添加版本号后值格式应为版本号在最后，如："INDEX:PART:ALL:BOE:1.0.5"
    String REDIS_INDEX_PART_DAILY = "INDEX:PART:DAILY:BOE:";//首页每日推荐

    //    String REDIS_INDEX_PART_2_2_1 = "INDEX:PART:2.2.1:";//首页栏目-课程推荐
    String REDIS_INDEX_BANNER = "INDEX:BANNER:BOE:";//首页banner
    String REDIS_INDEX_PART_ALL_1_0_0 = "INDEX:PART:ALL:BOE:";//首页栏目-图书专题,目前没有版本号，添加版本号后值格式应为版本号在最后，如："INDEX:PART:ALL:BOE:1.0.5"


    String REDIS_SURPASS_RATE = "BOE:SURPASS:RATE:";//超出百分比
    String REDIS_SURPASS_PARENT_RATE = "SURPASS:PARENT:RATE:";//父母超出百分比

    String REDIS_BOOK_WIKI = "BOOK:WIKI:";//百科分类

    /***************************************USER*************************************/
    String REDIS_USER_TOKEN = "USER:TOKEN:";//key:token value:用户的uid
    String REDIS_USER_TOKEN_INFO = "USER:TOKEN:INFO:";//key:用户的uid value:（code码+设备码+message）
    String USER_LOGIN_INFO = "USER:LOGIN:INFO:";//当前用户的账号信息（QQ+WEIXIN+SINA+phone）
    String REDIS_USER_DEVICE_NO = "USER:DEVICE:NO:";//key:设备码 value:在该设备最近登录用户的uid
    @Deprecated
    String REDIS_MOBILE_CODE = "BOE:MOBILE:CODE:";//key:手机号 value:验证码
    /**
     * 验证码发送区分用途，不在使用REDIS_MOBILE_CODE
     */
    String REDIS_MOBILE_CODE_LOGIN = "BOE:MOBILE:CODE:LOGIN:";//key:手机号 value:验证码
    String REDIS_MOBILE_CODE_RESET = "BOE:MOBILE:CODE:RESET:";//key:手机号 value:验证码
    String REDIS_HOME_MOBILE_CODE = "HOME:MOBILE:CODE:";
    String REDIS_HOME_MENU = "HOME:MENU:";
    String DISTRIBUTED_HIGH_CONCURRENCY_REGISTER_CHECK = "USER:DISTRIBUTED_HIGH_CONCURRENCY_REGISTER:";//key:
    String DISTRIBUTED_HIGH_CONCURRENCY_PACKING_CHECK = "BOOK:DISTRIBUTED_HIGH_CONCURRENCY_PACKING_CHECK:";//key:
    String USER_REGISTER_STATUS = "USER:REGISTER_STATUS:";//用户注册状态
    String REDIS_POINT_AD = "POINT:AD:";//积分广告
    /*************************************** 配置信息 *************************************/


    /*************************************** 闪屏广告 *************************************/
    String REDIS_STARTUP_AD = "STARTUP:AD:";

    /**
     * 教学模式 key:bookCode
     */
    String REDIS_TEACHING_MODE_INFO = "TEACHING_MODE:INFO:";//教学模式详情
    String REDIS_TEACHING_MODE_INFO_EDITEBY = "TEACHING_MODE:INFO:BEINGEDITEDBY:";//编辑教学模式当前页的用户
    long REDIS_TEACHING_MODE_INFO_EXPIRE = 3600;//教学模式的过期时间
    String REDIS_TEACHING_MODE_HTML_TOKEN = "TEACHING_MODE:HTML:TOKEN:";//教学模式当前页的权限token
    String REDIS_TEACHING_MODE_HTML_STATUS = "TEACHING_MODE:HTML:STATUS:";//教学模式当前的状态：只读，可读可写
    String REDIS_TEACHING_MODE_HTML_READ_ONLY = "TEACHING_MODE:HTML:READ:ONLY:";//教学模式当前是否为只读状态
    long REDIS_TEACHING_MODE_HTML_READ_ONLY_EXPIRE = 60;//教学模式当前是否为只读状态的过期时间
    String REDIS_TEACHING_MODE_PACKAGE_PERCENT = "TEACHING_MODE:PACKAGE:PERCENT:";//打包进度
    long REDIS_TEACHING_MODE_PACKAGE_PERCENT_EXPIRE = 60;
    String REDIS_TEACHING_MODE_PACKAGE_RESPONSE = "TEACHING_MODE:PACKAGE:RESPONSE:";//response对象
    long REDIS_TEACHING_MODE_PACKAGE_RESPONSE_EXPIRE = 60;
    String REDIS_TEACHING_MODE_PACKAGE_RECORD = "TEACHING_MODE:PACKAGE:RECORD:";//打包记录
    String REDIS_TEACHING_MODE_PACKAGE_PERCENT_INCR = "TEACHING_MODE:PACKAGE:PERCENT:INCR:";//用于计算百分比进度的毫秒值
    String REDIS_TEACHING_MODE_PACKAGE_STAGE = "TEACHING_MODE:PACKAGE:STAGE:";//打包已进行到的阶段
    String REDIS_TEACHING_MODE_PACKAGE_TIME_CONSUMING = "TEACHING_MODE:PACKAGE:TIMECONSUMING:";//当前图书教学模式打包总耗时
    String REDIS_TEACHING_MODE_PACKAGE_PACKINGBY = "TEACHING_MODE:PACKAGE:PACKINGBY:";//当前教模式的打包人

    String REDIS_ADVICE_STARTUP_POPUP = "ADVICE:STARTUP:POPUP:";//启动弹窗
    String REDIS_ADVICE_SPLASH_AD = "ADVICE:SPLASH:AD:";//闪屏广告
    String REDIS_ADVICE_SYSTEM_POPUP = "ADVICE:SYSTEM:POPUP:";//系统弹窗
    String REDIS_APP_PUSH_IOS_TEST_DEVICE_TOKEN_LIST = "APP:PUSH:IOS_TEST_DEVICE_TOKEN_LIST";//iOS测试设备友盟token列表
    String REDIS_APP_PUSH_ANDROID_TEST_DEVICE_TOKEN_LIST = "APP:PUSH:ANDROID_TEST_DEVICE_TOKEN_LIST";//android测试设备友盟token列表


    //首页定时推送
    String REDIS_OPERATION_INDEX_PAGE_PUBLISH_TIME_BOE = "PUBLISH:HOME:PAGE:UPDATETIME:BOE";// 首页最近更新时间（BOE）
    String REDIS_OPERATION_INDEX_PAGE_NEXT_PUBLISH_TIME_BOE = "PUBLISH:INDEX:PAGE:NEXT:PUBLISH:TIME:BOE";//首页的下次推送时间（BOE）

    //成长计划
    String REDIS_READ_PLAN_PUBLISH_TIME_BOE = "PUBLISH:READ:PLAN:UPDATETIME:BOE";// 成长计划最近更新时间（BOE）


    String REDIS_BOOK_PREVIEW_RESOURCE_VIDEO_FILE = "BOOK_PREVIEW_RESOURCE:VIDEO_FILE:";//图书视频预览资源


    /**
     * 数据统计 咿啦看书
     */
    String REDIS_ANALYSIS_DASHBOARD = "ANALYSIS:DATA:DASHBOARD:";
    String REDIS_ANALYSIS_DASHBOARD_SIMPLE = "ANALYSIS:DATA:DASHBOARD:SIMPLE";
    String REDIS_ANALYSIS_DASHBOARD_ACTUAL = "ANALYSIS:DATA:ACTUAL:DASHBOARD:";
    String REDIS_ANALYSIS_DAILY_DATA_ACTUAL = "ANALYSIS:DATA:ACTUAL:DAILY:";
    String REDIS_ANALYSIS_USER_TOKEN = "ANALYSIS:USER:TOKEN:";//key:token value:用户的uid
    String REDIS_ANALYSIS_USER_TOKEN_INFO = "ANALYSIS:USER:TOKEN:INFO:";//key:用户的uid value:（权限菜单）
    String REDIS_ANALYSIS_ANALYTIC_CACHE = "ANALYSIS:ANALYTIC:CACHE:";//ANALYTIC DB 缓存表
    String REDIS_ANALYSIS_SYNOPSIS = "ANALYSIS:DATA:SYNOPSIS:";//应用总览
    String REDIS_ANALYSIS_SYNOPSIS_DETAIL = "ANALYSIS:DATA:SYNOPSIS:DETAIL:";//应用总览详情
    String REDIS_ANALYSIS_SYNOPSIS_DETAIL_CHANNEL = "ANALYSIS:DATA:SYNOPSIS:DETAIL:CHANNEL:";//应用总览详情CHANNEL
    String REDIS_ANALYSIS_SYNOPSIS_TIME_SLOT = "ANALYSIS:DATA:SYNOPSIS:TIME:SLOT:";//应用总览时间段
    String REDIS_ANALYSIS_SYNOPSIS_TOP_CHANNEL = "ANALYSIS:DATA:SYNOPSIS:TOP:CHANNEL:";//应用总览top渠道
    String REDIS_ANALYSIS_SYNOPSIS_AREA_START = "ANALYSIS:DATA:SYNOPSIS:AREA:START:";//应用总览地域启动
    String REDIS_ANALYSIS_SYNOPSIS_REMAIN = "ANALYSIS:DATA:SYNOPSIS:REMAIN:";//应用总览留存
    String REDIS_ANALYSIS_USERTRENDS_ADDUSER = "ANALYSIS:DATA:USERTRENDS:ADDUSER:"; //用户趋势-新增用户
    String REDIS_ANALYSIS_USERTRENDS_PAYUSER = "ANALYSIS:DATA:USERTRENDS:PAYUSER:"; //用户趋势-付费用户
    String REDIS_ANALYSIS_USERTRENDS_STARTUSER = "ANALYSIS:DATA:USERTRENDS:STARTUSER:";//用户趋势-启动用户
    /**
     * 数据统计 动画绘本馆
     */
    String REDIS_ANALYSIS_ELLAHOME_DASHBOARD = "ANALYSIS:ELLAHOME:DASHBOARD:";
    String REDIS_ANALYSIS_ELLAHOME_ACTIVE_USER = "ANALYSIS:ELLAHOME:DASHBOARD:ACTIVE:USER";
    String REDIS_ANALYSIS_ELLAHOME_ACTIVE_USER_HISTORY = "ANALYSIS:ELLAHOME:DASHBOARD:ACTIVE:USER:HISTORY";
    String REDIS_ANALYSIS_ELLAHOME_ACTIVE_USER_CURRENT = "ANALYSIS:ELLAHOME:DASHBOARD:ACTIVE:USER:CURRENT ";
    String REDIS_ANALYSIS_ELLAHOME_PARTNER_INCREASE_USER = "ANALYSIS:ELLAHOME:PARTNER:INCREASE:USER:";
    String REDIS_ANALYSIS_ELLAHOME_PARTNER_INCREASE_PAY = "ANALYSIS:ELLAHOME:PARTNER:INCREASE:PAY:";


    /*
     * 活跃用户
     */
    String REDIS_ANALYSIS_ACTIVE_HISTORY = "ANALYSIS:DATA:ACTIVE:HISTORY:";//活跃用户历史数据
    String REDIS_ANALYSIS_ACTIVE = "ANALYSIS:DATA:ACTIVE:";//活跃用户用户数据
    String REDIS_ANALYSIS_ACTIVE_TIME_SLOT = "ANALYSIS:DATA:ACTIVE:TIME:SLOT:";//活跃用户时间段
    String REDIS_ANALYSIS_ACTIVE_DAILY_LIST = "ANALYSIS:DATA:ACTIVE:DAILY:LIST:";//活跃用户每日列表

    long REDIS_ANALYSIS_SYNOPSIS_EXPIRE_TIME = 60 * 60 * 24;
    long REDIS_ANALYSIS_SYNOPSIS_USER_DATA_EXPIRE_TIME = 5 * 60;
    long APP_LB_DATA_EXPIRE_TIME = 60;

    /**
     * 资源大小字节数
     */
    String REDIS_BOOK_MODE_RESOURCE_BYTES = "BOOK:RESOURCE:BYTES:FORMAL:";
    long REDIS_BOOK_MODE_RESOURCE_BYTES_EXPIRE_TIME = 60 * 60 * 24 * 7;

    String REDIS_TEACHING_MODE_RESOURCE_BYTES = "BOOK:RESOURCE:BYTES:TEACHING:FORMAL:";
    long REDIS_TEACHING_MODE_RESOURCE_BYTES_EXPIRE_TIME = 60 * 60 * 24 * 7;

    /**
     * 数据分析Redis有效期时间
     */
    long REDIS_ANALYSIS_EXPIRE_TIME = 2 * 60;

    /**
     * 注册答题送书的默认答题结果
     */
    String USER_REGISTER_SEND_BOOK_DEFAULT_ANSWER = "USER:REGISTER:ANSWER:DEFAULT:";

    /**
     * 闪屏广告推送时间
     */
    String STARTUP_AD_PUSH_TIME = "STARTUP:AD:PUSH_TIME";
    String STARTUP_AD_PUSHING_TIME = "STARTUP:AD:PUSHING_TIME:";

    /**
     * 图书包
     */
    String REDIS_BOOKPACKAGE_DETAIL = "BOOKPACKAGE:DETAIL:";

    /**
     * 课程
     */
    String REDIS_COURSE_DETAIL = "COURSE:DETAIL:";

    //课时
    String REDIS_CHAPTER_DETAIL = "CHAPTER:DETAIL:";

    /**
     * 咿啦家园拉取动画书信息KEY
     */
    String key_prefix = "HOME_PULL_BOOK:";

    /**
     * 听书首页模块data缓存redis_key
     * */
    /*String LB_APP_DATA_KEY ="ELLA:APP:DATA:LB:LB_APP_DATA";*/
    String LB_APP_DATA_KEY ="ELLA:APP:DATA:LB:LB_DATA";

    /**
     * 听单 列表样式   HORIZONTAL_NO_SUBTITLE:横排无音频副标题
     */
    String LB_LISTEN_LIST_TYPE_NO_SUBTITLE = "HORIZONTAL_NO_SUBTITLE";


    /**
     * 睡前听页面标识
     * */
    String LISTEN_SLEEP = "LISTEN_SLEEP";

    String LISTEN_CODE = "\\{listenCode}";

    String PART_TYPE = "\\{partType}";

    String LIST_TYPE = "\\{listType}";

    String TITLE = "\\{title}";

    /**
     * 听书听单模块横板展示路由code
     * */
    String LB_LISTEN_HORIZONTAL_NO_SUBTITLE = "LB_LISTEN_HORIZONTAL_NO_SUBTITLE";


    int MAX_PAGE_SIZE = 1000;
    /**
     * 听书播放器路由Code
     * */
    String LB_PLAYER = "LB_PLAYER";

    /**
     * 音频分类缓存rediskey
     * */
    String LB_AUDIO_SORT_KEY ="ELLA:APP:DATA:LB:AUDIO_SORT";
    /**
     * 图书合集
     */
    String REDIS_BOOK_SERIES_DETAIL = "BOOK:SERIES:DETAIL:";

    /**
     * 热门搜索
     */
    String REDIS_APP_SEARCH_POPULARSEARCH = "APP:SEARCH:POPULARSEARCH";

    /**
     * 听书首页分类固定code
     */
    String LB_HOME_PAGE_CLASS_CODE = "WKSORT99";

    /**
     * 书籍百科分类v2.4.1
     */
    String REDIS_BOOK_CLASSIFIED = "BOOK:CLASSIFIED:";

    /**
     * 福卡活动抽奖
     */
    String REDIS_ACTIVITY_DRAW_FK = "ACTIVITY:DRAW:FK:";
    /**
     * 阅读报告 v2.4.3
     */
    String REDIS_USER_READ_PRESENTATION = "BOE:USER:READ:PRESENTATION:";

    /*国家编号*/
    String COUNTRY_CODE = "USER:COUNTRY:CODE:";
    /**
     * 图书专题 v2.4.7
     */
    String REDIS_BOOK_SUBJECT_PURCHASE_NOTES = "BOOK:SUBJECT:PURCHASE:NOTES:";

    String BOE_ACTIVATION_DEVICE_INFO = "BOE:DEVICE:INFO:";

    String BOE_CHILDREN_INFO = "BOE:CHILDREN:INFO:";


    String USER_MOBILE = "USER:MOBILE:";

    String BOE_STUDY_BOOKS_NORMAL_INFO = "BOE:STUDY:NORMALBOOKSINFO:";
    String BOE_STUDY_BOOKS_IPHONE2208_INFO = "BOE:STUDY:IPHONE2208BOOKSINFO:";
    /**
     * TODO 中台增加配置新设备赠送20本图书功能后，功能中每次更新资源需要删除BOE_DEVICE_STUDY_BOOKINFO这个key
     */
    String BOE_DEVICE_STUDY_RESOURCE_VERSION = "BOE:DEVICE:STUDY:RESOURCE:VERSION:";
    String BOE_DEVICE_STUDY_BOOKINFO = "BOE:DEVICE:STUDY:BOOKINFO:";

    String BOE_DEVICE_STUDY_MECH_RESOURCE_VERSION = "BOE:DEVICE:STUDY:MECH_RESOURCE:VERSION:";
    String BOE_DEVICE_STUDY_MECH_BOOKINFO = "BOE:DEVICE:STUDY:MECH_BOOKINFO:";

    long REDIS_BOE_STUDY_BOOKS_INFO_EXPIRE = 3600;

    /**
     * 获取boe用户书籍的useState用以在百科分类中展示用户图书拥有状态
     */
    String BOE_STUDY_BOOK_STATE = "BOE:STUDY:BOOK:STATE:";

    String DEVICE_LOGIN_MEMBER = "DEVIC:ELOGIN:MEMBER:";
    /**
     * 当前设备登录的用户类型
     */
    String DEVICE_LOGIN_USER_TYPE = "DEVICE:LOGIN:USER:TYPE:";
    String DEVICE_LOGIN_EXPIRE = "DEVIC:ELOGIN:EXPIRE:";
    /**
     * 学生使用机构特色功能的权限，值为 用户类型
     */
    String DEVICE_FUNCTION_RIGHT = "DEVICE:FUNCTION:RIGHT:";

    String READ_PLAN_NEWWEEK = "BOE:STUDY:READPLAN:NEWWEEK:";

}