package com.ella.util;

import com.ella.entity.operation.User;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/8/19 16:44
 * @Description:分批处理list集合工具类
 * @Modified:
 */
public class BatchHandlerUtil<T> {
    /**
     * 通过自定义分批参数      例如list.size() = 10000  ； batchSize = 1000  ； 分成10组进行resolve 操作
     *
     * @param list      需要拆分的集合
     * @param batchSize 拆分大小
     * @param resolve   根据批量操作插入数据库的方法
     */
    public void batchResolve(List<T> list, int batchSize, BatchProcess resolve) {
        //集合为空直接返回
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (int i = 0; i < list.size(); i += batchSize) {
            int end = i + batchSize;
            if (end > list.size()) {
                end = list.size();
            }
            List<T> items = list.subList(i, end);
            resolve.resolve(items);
        }
    }

    public static void main(String[] args) {
        List<User> userList = new ArrayList<>();
        User user = User.builder().userAccount("F1111").userName("张三").build();
        userList.add(user);
        new BatchHandlerUtil<User>().batchResolve(userList,1000,(item)->{
             //批量插入
            //userMapper.batchAddUser(item);
        });
    }
}
