package com.ella.util;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;

/**
 * Created by Administrator on 2018/1/12.
 */
public class Base64Util {

    /**
     * base64纯字符串解码
     *
     * @param base64EnCodeString
     * @return
     * @throws IOException
     */
    public static String decodeBase64Str(String base64EnCodeString) throws IOException {
        byte[] decode = Base64.getDecoder().decode(base64EnCodeString);
        InputStream inputStream = InputStreamUtil.string2InputStream(decode);
        return InputStreamUtil.inputStream2String(inputStream);
    }

    /**
     * base64图片解码
     *
     * @param file
     * @return
     * @throws IOException
     */
    public static byte[] decodeBase64File(String file) throws IOException {
        //imageFile = imageFile.replaceAll("data:image/jpeg;base64,", "");
        String substring = file.substring(0, file.indexOf(',') + 1);
        file = file.replaceAll(substring, "");
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] b = decoder.decodeBuffer(file);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] < 0) {// 调整异常数据
                b[i] += 256;
            }
        }
        return b;
    }

    /**
     * BASE64加密
     * @param str
     * @return
     */
    public static String encodeBASE64(String str) {
        byte[] b = str.getBytes();
        String s = null;
        if (b != null) {
            s = new BASE64Encoder().encode(b);
        }
        return s;
    }

}
