package com.ella.template;

import org.jeecgframework.poi.excel.annotation.Excel;

import javax.validation.constraints.NotNull;

/**
 * 班级导入导出的excel模板
 *
 * @author LiBin
 **/
public class ClassTemplate {

    @Excel(name = "行号", orderNum = "1", isImportField = "rowNum")
    @NotNull(message = "不可为空")
    private int rowNum;

    @Excel(name = "入学年份", orderNum = "2", isImportField = "enrolYear")
    @NotNull(message = "不可为空")
    private String enrolYear;

    @Excel(name = "年级", orderNum = "3", isImportField = "gradeName")
    @NotNull(message = "不可为空")
    private String gradeName;

    @Excel(name = "班级名称", orderNum = "4", isImportField = "className")
    @NotNull(message = "不可为空")
    private String className;

    @Excel(name = "学生姓名", orderNum = "5", isImportField = "studentName")
    @NotNull(message = "不可为空")
    private String studentName;

    @Excel(name = "家长手机号对应国际区号", orderNum = "6", isImportField = "countryCode")
    @NotNull(message = "不可为空")
    private String countryCode;

    @Excel(name = "家长手机号", orderNum = "7", isImportField = "phone", width = 20)
    @NotNull(message = "不可为空")
    private String phone;

    @Excel(name = "家长角色", orderNum = "8", isImportField = "roleName")
    @NotNull(message = "不可为空")
    private String roleName;

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getEnrolYear() {
        return enrolYear;
    }

    public void setEnrolYear(String enrolYear) {
        this.enrolYear = enrolYear;
    }

    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getStudentName() {
        return studentName;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public int getRowNum() {
        return rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public static ClassTemplate getDefault() {
        ClassTemplate template = new ClassTemplate();
        template.setRowNum(1);
        template.setEnrolYear("2018");
        template.setGradeName("大班");
        template.setClassName("大一班");
        template.setStudentName("小明");
        template.setCountryCode("+86");
        template.setPhone("133********");
        template.setRoleName("妈妈");
        return template;
    }

    public static ClassTemplate getDefault(String countryCode) {
        ClassTemplate aDefault = getDefault();
        aDefault.setCountryCode(countryCode);
        return aDefault;
    }

    @Override
    public String toString() {
        return "ClassTemplate{" +
                "rowNum='" + rowNum + '\'' +
                ", enrolYear='" + enrolYear + '\'' +
                ", gradeName='" + gradeName + '\'' +
                ", className='" + className + '\'' +
                ", studentName='" + studentName + '\'' +
                ", countryCode='" + countryCode + '\'' +
                ", phone='" + phone + '\'' +
                ", roleName='" + roleName + '\'' +
                '}';
    }
}
