package com.ella.push;

import com.alibaba.fastjson.JSONObject;
import com.ella.push.android.AndroidUnicast;
import com.ella.push.ios.IOSUnicast;


public class MessagePush {
    private String iosAppKey = MessagePushUtil.IOS_APPKEY.getType();
    private String androidAppKey = MessagePushUtil.ANDROID_APPKEY.getType();
    private String androidAppMasterSecret = MessagePushUtil.ANDROID_APPMASTERSECRET.getType();
    private String iosAppMasterSecret = MessagePushUtil.IOS_APPMASTERSECRET.getType();
    private PushClient client = new PushClient();

    public boolean sendAndroidUnicast(String deviceToken, JSONObject json) throws Exception {
        AndroidUnicast unicast = new AndroidUnicast(androidAppKey, androidAppMasterSecret);
        unicast.setDeviceToken(deviceToken);
        unicast.setTicker("Android unicast ticker");
        unicast.setTitle(json.getString("alert"));
        unicast.setText(json.getString("alert"));
        unicast.goAppAfterOpen();
        unicast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);

        unicast.setCustomField(json.toString());
        // TODO Set 'production_mode' to 'false' if it's a test device.
        // For how to register a test device, please see the developer doc.
//        unicast.setProductionMode();
        unicast.setTestMode();

        // Set customized fields
        unicast.setExtraField("test", "helloworld");
        return client.send(unicast);
    }

    public boolean sendIOSUnicast(String deviceToken, JSONObject json) throws Exception {
        IOSUnicast unicast = new IOSUnicast(iosAppKey, iosAppMasterSecret);
        unicast.setDeviceToken(deviceToken);
        unicast.setAlert(json.getString("alert"));
        unicast.setBadge(0);
        unicast.setContentAvailable(1);
        unicast.setSound("default");
        // TODO set 'production_mode' to 'true' if your app is under production mode
//        unicast.setProductionMode();
        unicast.setTestMode();
        // Set customized fields

        unicast.setCustomizedField("custom", json.toString());
        return client.send(unicast);
    }

}
