package com.ella.entity.operation.res.project;

import com.ella.entity.operation.dto.project.BookDto;
import com.ella.entity.operation.dto.project.BookInformationDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author: wqq
 * @Date: 2021/5/17 14:59
 * @Description:
 * @Modified:
 */
@Data
public class ProjectDetailRes {
    /**
     * 项目编码
     */
    private String projectCode;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 是否是复制的项目  是：YES  否：NO
     */
    private String isCopy;
    /**
     * 项目类型
     */
    private String typeCode;
    /**
     * 年份
     */
    private Integer year;
    /**
     * 学年
     */
    private String season;
    /**
     * 项目要求文件
     */
    private String requirement;
    /**
     * 项目要求文件地址，多个英文分号隔开
     */
    private String requirementFile;
    /**
     * 项目定价类型
     */
    private String priceType;
    /**
     * 最低价格
     */
    private BigDecimal minPrice;
    /**
     * 最高价格
     */
    private BigDecimal maxPrice;
    /**
     * 审核状态，草稿：DRAFT；待审核：WAITING；已退回：RETURNED；已审核：CHECKED
     */
    private String checkStatus;
    /**
     * 图书信息备注
     */
    private String bookRemark;
    /**
     * 项目对应图书数目
     */
    private Integer bookNum;
    /**
     * 项目对应文件数
     */
    private Integer fileNum;
    /**
     * 项目命名规则
     */
    private String nameRule;
    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date startTime;
    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date endTime;
    /**
     * 图书信息列表
     */
    private List<BookInformationDto> bookInformationList;
    /**
     * 图书集合
     */
    private List<BookDto> bookDtoList;
    /**
     * 装帧流程编码
     */
    private String bindingProcessCode;
    /**
     * 装帧节点编码
     */
    private String bindingNodeCode;
    /**
     * 装帧第一节点指派人用户编码
     */
    private String bindingUserCode;
    /**
     * 装帧第一节点指派人用户姓名
     */
    private String bindingUserName;
    /**
     * 编排校流程编码
     */
    private String bookProcessCode;
    /**
     * 编排校节点编码
     */
    private String bookNodeCode;
    /**
     * 项目审核文本
     */
    private String checkInfo;
    /**
     * 项目审核文件
     */
    private String checkFile;
    /**
     * 创建项目流程编码
     */
    private String createProjectNodeCode;

    /**
     * 节点名称
     */
    private String nodeName;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建时间
     */
    private String createTime;
}
