package com.ella.entity.operation.res.project;

import com.ella.entity.operation.dto.project.BookInformationDto;
import com.ella.entity.operation.dto.project.ProjectBookListDto;
import com.ella.entity.operation.dto.project.ProjectBookProcessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/6/29 10:12
 * @Description:
 * @Modified:
 */
@Data
public class MyProjectDetailRes {
    /**
     * 项目编码
     */
    private String projectCode;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 是否是复制的项目  是：YES  否：NO
     */
    private String isCopy;
    /**
     * 项目类型
     */
    private String typeCode;
    /**
     * 年份
     */
    private Integer year;
    /**
     * 学年
     */
    private String season;
    /**
     * 项目要求文本
     */
    private String requirement;
    /**
     * 项目要求文件地址，多个英文分号隔开
     */
    private String requirementFile;
    /**
     * 项目定价类型
     */
    private String priceType;
    /**
     * 最低价格
     */
    private BigDecimal minPrice;
    /**
     * 最高价格
     */
    private BigDecimal maxPrice;
    /**
     * 审核状态，草稿：DRAFT；待审核：WAITING；已退回：RETURNED；已审核：CHECKED
     */
    private String checkStatus;
    /**
     * 图书信息备注
     */
    private String bookRemark;
    /**
     * 项目对应图书数目
     */
    private Integer bookNum;
    /**
     * 项目对应文件数
     */
    private Integer fileNum;
    /**
     * 项目命名规则
     */
    private String nameRule;
    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date startTime;
    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date endTime;
    /**
     * 图书信息列表
     */
    private List<BookInformationDto> bookInformationList;
    /**
     * 项目审核意见
     */
    private String projectCheckInfo;
    /**
     * 项目审核文件
     */
    private String projectCheckFile;
    /**
     * 项目-图书列表
     */
    private List<ProjectBookListDto> projectBookList;
    /**
     * 项目审核人编码
     */
    private String projectCheckUserCode;
    /**
     * 项目审核人名称
     */
    private String projectCheckUserName;
    /**
     * 装帧设计流程编码
     */
    private String bindingProcessCode;
    /**
     * 装帧设计流程名称
     */
    private String bindingProcessName;
    /**
     * 编排校流程编码
     */
    private String proofreadProcessCode;
    /**
     * 编排校流程名称
     */
    private String proofreadProcessName;
    /**
     *项目-图书-流程信息
     */
    private List<ProjectBookProcessDto> projectBookProcessList;

}
