package com.ella.entity.operation.req.workSpace;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.math.BigDecimal;

/**
 * @author: wqq
 * @Date: 2021/7/1 16:34
 * @Description:
 * @Modified:
 */
@Data
public class TaskClaimReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 类型 PROJECT_CHECK GRAPHIC_DESIGN  PROOFREAD
     */
    @NotBlank(message = "类型" + ERROR_MSG)
    private String type;
    /**
     * 逻辑编码
     */
    @NotBlank(message = "逻辑编码" + ERROR_MSG)
    private String logicCode;
    /**
     * 项目编码
     */
    @NotBlank(message = "项目编码" + ERROR_MSG)
    private String projectCode;
    /**
     * 抢单任务标志 是 REWARD 否 ""
     */
    private String rewardFlag;
    /**
     * 悬赏系数
     */
    private BigDecimal rewardCoefficient;
}
