package com.ella.entity.operation.req.user;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @author: wqq
 * @Date: 2021/4/20 15:19
 * @Description:
 * @Modified:
 */
@Data
public class UserLoginReq{
    private static final String ERROR_MSG = "不能为空";
    /**
     * 账号
     */
    @NotBlank(message = "账号" + ERROR_MSG)
    private String account;
    /**
     * 密码
     */
    @NotBlank(message = "密码" + ERROR_MSG)
    private String password;
    /**
     * 是否15天自动登录 TRUE 是  FALSE 否
     */
    @NotBlank(message = "自动登录标识" + ERROR_MSG)
    private String rememberFlag;
    /**
     * 系统名称  流程管理  编排工具
     */
    @NotBlank(message = "系统名称" + ERROR_MSG)
    private String systemName;
}
