package com.ella.entity.operation.req.user;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/4/23 15:12
 * @Description:
 * @Modified:
 */
@Data
public class EditUserReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     *用户编码
     */
    @NotBlank(message = "用户编码" + ERROR_MSG)
    private String userCode;
    /**
     *用户姓名
     */
    @NotBlank(message = "用户姓名" + ERROR_MSG)
    private String userName;
    /**
     *手机号
     */
    @NotBlank(message = "手机号" + ERROR_MSG)
    private String phone;
    /**
     *工号
     */
    @NotBlank(message = "工号" + ERROR_MSG)
    private String userAccount;
    /**
     * 性别
     */
    private String sex;
    /**
     *部门编码集合
     */
    private List<String> departCodeList;
    /**
     *角色编码集合
     */
    private List<String> roleCodeList;
}
