package com.ella.entity.operation.req.user;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/4/23 16:49
 * @Description:
 * @Modified:
 */
@Data
public class AddUserReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 工号
     */
    @NotBlank(message = "工号" + ERROR_MSG)
    private String userAccount;
    /**
     * 用户姓名
     */
    @NotBlank(message = "用户姓名" + ERROR_MSG)
    private String userName;
    /**
     * 手机号
     */
    @NotBlank(message = "手机号" + ERROR_MSG)
    private String phone;
    /**
     * 性别
     */
    private String sex;
    /**
     * 部门集合编码
     */
    private List<String> departCodeList;
    /**
     * 角色集合编码
     */
    private List<String> roleCodeList;
}
