package com.ella.entity.operation.req.role;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/4/27 11:49
 * @Description:
 * @Modified:
 */
@Data
public class EditRoleReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 角色编码
     */
    @NotBlank(message = "角色编码" + ERROR_MSG)
    private String roleCode;
    /**
     * 角色名称
     */
    @NotBlank(message = "角色名称" + ERROR_MSG)
    @Size(message = "角色名称最多可输入20个字",max = 20)
    private String roleName;
    /**
     * 菜单编码及功能编码
     */
    private List<String> codeStr;
}
