package com.ella.entity.operation.req.proofreadNodeOperation;

import com.ella.entity.operation.dto.proofreadNodeOperation.AllocationBookListDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/5/24 17:23
 * @Description:
 * @Modified:
 */
@Data
public class TaskAllocationReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 编排校编码(任务分配属于编排流程)
     */
    @NotBlank(message = "编排校编码" + ERROR_MSG)
    private String bpnuCode;
    /**
     * 下一节点编码(只有点击完成的时候才有)
     */
    private String nextNodeCode;
    /**
     * 操作类型 草稿：DRAFT  完成：FINISH
     */
    @NotBlank(message = "操作类型" + ERROR_MSG)
    private String operationType;
    /**
     * 任务分配列表
     */
    private List<AllocationBookListDto> allocationBookList;
    /**
     * 悬赏系数
     */
    private BigDecimal rewardCoefficient;
    /**
     * 任务限时
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date taskTimeLimit;
}
