package com.ella.entity.operation.req.proofreadNodeOperation;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/5/20 15:37
 * @Description:
 * @Modified:
 */
@Data
public class ReturnProjectProcessNodeReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 逻辑编码  ppnuCode或者bpnuCode
     */
    @NotBlank(message = "逻辑编码" + ERROR_MSG)
    private String logicCode;
    /**
     * 项目编码
     */
    @NotBlank(message = "项目编码" + ERROR_MSG)
    private String projectCode;
    /**
     * 操作类型 项目：PROJECT  装帧：GRAPHIC_DESIGN 编排校：PROOFREAD
     */
    @NotBlank(message = "操作类型" + ERROR_MSG)
    private String operationType;
    /**
     * 当前节点编码
     */
    @NotBlank(message = "当前节点编码" + ERROR_MSG)
    private String currentNode;
    /**
     * 退回节点编码
     */
    @NotBlank(message = "退回节点编码" + ERROR_MSG)
    private String returnNodeCode;
    /**
     * 指派人编码集合
     */
    private List<String> userCodeList;
}
