package com.ella.entity.operation.req.proofreadNodeOperation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/6/9 17:24
 * @Description:
 * @Modified:
 */
@Data
public class BookInformationSettingReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 操作类型  草稿：DRAFT  完成：FINISH
     */
    @NotBlank(message = "操作类型" + ERROR_MSG)
    private String operationType;
    /**
     * 编排校编码
     */
    @NotBlank(message = "编排校编码" + ERROR_MSG)
    private String bpnuCode;
    /**
     * 图书编码
     */
    @NotBlank(message = "图书编码" + ERROR_MSG)
    private String bookCode;
    /**
     * 下一节点编码
     */
    private String nextNodeCode;
    /**
     * 节点指派人
     */
    private List<String> userCodeList;
    /**
     * 审核意见
     */
    private String checkInfo;
    /**
     * 审核文件
     */
    private String checkFile;

    /**
     * 悬赏系数
     */
    private BigDecimal rewardCoefficient;
    /**
     * 任务限时
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date taskTimeLimit;
}
