package com.ella.entity.operation.req.project;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @author: wqq
 * @Date: 2021/5/20 14:47
 * @Description:
 * @Modified:
 */
@Data
public class ProjectCheckReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 项目编码
     */
    @NotBlank(message = "项目编码" + ERROR_MSG)
    private String projectCode;
    /**
     * 逻辑编码
     */
    @NotBlank(message = "逻辑编码" + ERROR_MSG)
    private String ppnuCode;
    /**
     * 审核操作类型  草稿：DRAFT  完成：FINISH
     */
    @NotBlank(message = "审核操作类型" + ERROR_MSG)
    private String checkStatus;
    /**
     * 审核意见
     */
    private String checkInfo;
    /**
     * 审核文件(多个英文逗号隔开)
     */
    private String checkFile;
}
