package com.ella.entity.operation.req.project;

import com.ella.entity.PageParam;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @author: wqq
 * @Date: 2021/5/19 14:50
 * @Description:
 * @Modified:
 */
@Data
public class AllProjectListReq extends PageParam {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 搜索关键字 项目名称
     */
    private String projectName;
    /**
     * tab类型  已完成 FINISHED 未完成 DOING
     */
    @NotBlank(message = "tab类型" + ERROR_MSG)
    private String tabType;
    /**
     * 创建人编码
     */
    private String createProjectCode;
    /**
     * 排序标识 创建时间正序 CREATETIMEASC 创建时间倒序 CREATETIMEDESC 完成时间正序 FINISHTIMEASC 完成时间倒序 FINISHTIMEDESC
     */
    @NotBlank(message = "排序标识" + ERROR_MSG)
    private String sortMark;
}
