package com.ella.entity.operation.req.project;

import com.ella.entity.operation.dto.project.BookDto;
import com.ella.entity.operation.dto.project.BookInformationDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author: wqq
 * @Date: 2021/5/14 9:57
 * @Description:
 * @Modified:
 */
@Data
public class AddProjectReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 操作类型  草稿：DRAFT  完成：FINISH
     */
    @NotBlank(message = "操作类型" + ERROR_MSG)
    private String operationType;
    /**
     * 复制项目编辑 是：YES 否：NO(编辑项目直接copy)
     */
    private String whetherCopyType;
    /**
     * 项目名称
     */
    @NotBlank(message = "项目名称" + ERROR_MSG)
    private String projectName;
    /**
     * 年份
     */
    private Integer year;
    /**
     * 学年
     */
    private String season;
    /**
     * 项目类型
     */
    private String typeCode;
    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date startTime;
    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date endTime;
    /**
     * 项目定价类型
     */
    private String priceType;
    /**
     * 最低价格
     */
    private BigDecimal minPrice;
    /**
     * 最高价格
     */
    private BigDecimal maxPrice;
    /**
     * 项目对应图书数目
     */
    private Integer bookNum;
    /**
     * 项目对应文件数
     */
    private Integer fileNum;
    /**
     * 项目要求文件
     */
    private String requirement;
    /**
     * 项目要求文件地址，多个英文分号隔开
     */
    private String requirementFile;
    /**
     * 图书信息备注
     */
    private String bookRemark;
    /**
     * 项目命名规则
     */
    private String nameRule;
    /**
     * 图书信息列表
     */
    private List<BookInformationDto> bookInformationList;
    /**
     * 图书集合
     */
    private List<BookDto> bookDtoList;
    /**
     * 装帧流程编码
     */
    private String bindingProcessCode;
    /**
     * 装帧节点编码
     */
    private String bindingNodeCode;
    /**
     * 装帧第一节点指派人用户编码
     */
    private String bindingUserCode;
    /**
     * 编排校流程编码
     */
    private String bookProcessCode;
    /**
     * 编排校节点编码
     */
    private String bookNodeCode;
    /**
     * 新建项目流程编码
     */
    @NotBlank(message = "新建项目流程编码" + ERROR_MSG)
    private String createProjectNodeCode;
    /**
     * 新建项目点击完成下一操作节点编码(项目审核)
     */
    private String nextNodeCode;
    /**
     * 新建项目点击完成下一操作被指派人(项目审核)
     */
    private List<String> nextUserCodeList;
}
