package com.ella.entity.operation.req.project;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @author: wqq
 * @Date: 2021/10/8 13:58
 * @Description:
 * @Modified:
 */
@Data
public class AddFormatReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 图书编码
     */
    @NotBlank(message = "图书编码" + ERROR_MSG)
    private String bookCode;
    /**
     * 图书结构
     */
    @NotBlank(message = "图书结构" + ERROR_MSG)
    private String bookType;
    /**
     * 图书逻辑编码
     */
    @NotBlank(message = "图书逻辑编码" + ERROR_MSG)
    private String baseBookCode;
    /**
     * 页面大小 关联es_enum的enum_code，且type=FORMAT
     */
    private String formatSize;
    /**
     * 宽度
     */
    private String weight;
    /**
     * 高度
     */
    private String height;
    /**
     * 是否单面印刷，YES|NO
     */
    private String isOneSideBrush;
    /**
     * 是否双面排版，YES|NO
     */
    private String isTwoSideLayout;
    /**
     * 是否起始页为右页，YES|NO
     */
    private String isBeginRight;
    /**
     * 页面边距-上-顶
     */
    private String pageTop;
    /**
     * 页面边距-下-底
     */
    private String pageDown;
    /**
     * 页面边距-左-外
     */
    private String pageLeft;
    /**
     * 页面边距-右-内
     */
    private String pageRight;
    /**
     * 纸张方向，水平：HORIZONTAL;；垂直：VERTICAL
     */
    private String pageDirection;
    /**
     * 排版方向，水平：HORIZONTAL;；垂直：VERTICAL
     */
    private String layoutDirection;
    /**
     * 装订次序 左装订:LEFT，右装订：RIGHT
     */
    private String bindingType;
    /**
     * 起始页码
     */
    private Integer homePageNum;
    /**
     * 是否全部标记，YES|NO
     */
    private String isAllTag;
    /**
     * 是否裁切标记，YES|NO
     */
    private String cuttingTag;
    /**
     * 是否出血标记，YES|NO
     */
    private String bloodTag;
    /**
     * 是否套位标记，YES|NO
     */
    private String nestingTag;
    /**
     * 线长
     */
    private String lineWeight;
    /**
     * 线宽
     */
    private String lineHeight;
    /**
     * 类型 关联es_enum的enum_code，且type=NESTING
     */
    private String tagType;
    /**
     * 出血-上-顶
     */
    private String bloodTop;
    /**
     * 出血-下-底
     */
    private String bloodDown;
    /**
     * 出血-左-外
     */
    private String bloodLeft;
    /**
     * 出血-右-内
     */
    private String bloodRight;
    /**
     * 警戒-上-顶
     */
    private String alarmTop;
    /**
     * 警戒-下-底
     */
    private String alarmDown;
    /**
     * 警戒-左-外
     */
    private String alarmLeft;
    /**
     * 警戒-右-内
     */
    private String alarmRight;
}
