package com.ella.entity.operation.req.process;

import com.ella.entity.operation.dto.process.ProcessNodeDto;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/5/10 13:47
 * @Description:
 * @Modified:
 */
@Data
public class EditProcessReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 流程编码
     */
    @NotBlank(message = "流程编码" + ERROR_MSG)
    private String processCode;
    /**
     * 工作流名称
     */
    @NotBlank(message = "工作流名称" + ERROR_MSG)
    private String processName;

    /**
     * 创建项目： CREATE_PROJECT   编排校：PROOFREAD；装帧设计：GRAPHIC_DESIGN
     */
    @NotBlank(message = "流程类型" + ERROR_MSG)
    private String processType;
    /**
     * 流程节点集合
     */
    private List<ProcessNodeDto> nodeList;
    /**
     * 操作类型  草稿：DRAFT  完成：FINISH
     */
    @NotBlank(message = "操作类型" + ERROR_MSG)
    private String operationType;
}
