package com.ella.entity.operation.req.esEnum;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/11/15 9:57
 * @Description:
 * @Modified:
 */
@Data
public class EditEnumSortReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 图书命名类型  通用：CURRENCY  试卷：PAPER  自定义：CUSTOM
     */
    @NotBlank(message = "图书命名类型" + ERROR_MSG)
    private String bookNameType;
    /**
     * 名称
     */
    @NotBlank(message = "名称" + ERROR_MSG)
    private String typeName;
    /**
     * 枚举选项编码(将整个名称下的选项按照顺序封装)
     */
    private List<String> enumCodeList;
}
