package com.ella.entity.operation.req.esEnum;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/11/11 16:37
 * @Description:
 * @Modified:
 */
@Data
public class EditEnumReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 名称
     */
    @NotBlank(message = "名称" + ERROR_MSG)
    private String typeName;
    /**
     * 名称是否编辑 是 TRUE 否 FALSE
     */
    @NotBlank(message = "名称是否编辑" + ERROR_MSG)
    private String isEdit;
    /**
     * 没改变之前的名称  isEdit是TRUE必传
     */
    private String originalTypeName;
    /**
     * 选项集合(只需要传新增的)
     */
    private List<String> enumNameList;
    /**
     * 图书命名类型  通用：CURRENCY  试卷：PAPER  自定义：CUSTOM
     */
    @NotBlank(message = "图书命名类型" + ERROR_MSG)
    private String bookNameType;
}
