package com.ella.entity.operation.req.esEnum;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/11/11 16:36
 * @Description:
 * @Modified:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AddEnumReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 名称
     */
    @NotBlank(message = "名称" + ERROR_MSG)
    private String typeName;
    /**
     * 选项集合
     */
    private List<String> enumNameList;
    /**
     * 图书命名类型  通用：CURRENCY  试卷：PAPER  自定义：CUSTOM
     */
    @NotBlank(message = "图书命名类型" + ERROR_MSG)
    private String bookNameType;
}
