package com.ella.entity.operation.req.bindingNodeOperation;

import com.ella.entity.operation.dto.bindingNodeOperation.BookFileFormatSetListDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/6/7 11:50
 * @Description:
 * @Modified:
 */
@Data
public class FormatSetSettingReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 逻辑编码(工作台列表会返回)
     */
    @NotBlank(message = "逻辑编码" + ERROR_MSG)
    private String ppnuCode;
    /**
     * 项目编码
     */
    @NotBlank(message = "项目编码" + ERROR_MSG)
    private String projectCode;
    /**
     * 操作类型  草稿：DRAFT  完成：FINISH
     */
    @NotBlank(message = "操作类型" + ERROR_MSG)
    private String operationType;
    /**
     * 图书-文件-版式列表
     */
    private List<BookFileFormatSetListDto> bookFileFormatSetList;
    /**
     * 下一节点编码
     */
    private String nextNodeCode;
    /**
     * 节点指派人
     */
    private List<String> userCodeList;
    /**
     * 悬赏系数
     */
    private BigDecimal rewardCoefficient;
    /**
     * 任务限时
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date taskTimeLimit;
}
