package com.ella.entity.operation.req.bindingNodeOperation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/6/8 16:53
 * @Description:
 * @Modified:
 */
@Data
public class CoverSampleSettingReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 操作类型  草稿：DRAFT  完成：FINISH
     */
    @NotBlank(message = "操作类型" + ERROR_MSG)
    private String operationType;
    /**
     * 逻辑编码(工作台列表会返回)
     */
    @NotBlank(message = "逻辑编码" + ERROR_MSG)
    private String ppnuCode;
    /**
     * 项目编码
     */
    @NotBlank(message = "项目编码" + ERROR_MSG)
    private String projectCode;
    /**
     * 封面样张图片地址
     */
    @NotBlank(message = "封面样张图片地址" + ERROR_MSG)
    private String coverSampleFile;
    /**
     * 备注
     */
    private String remark;
    /**
     * 下一流程节点编码
     */
    private String nextNodeCode;
    /**
     * 流程节点被指派人编码
     */
    private List<String> userCodeList;
    /**
     * 悬赏系数
     */
    private BigDecimal rewardCoefficient;
    /**
     * 任务限时
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date taskTimeLimit;
}
