package com.ella.entity.operation.req.bindingNodeOperation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/6/8 17:19
 * @Description:
 * @Modified:
 */
@Data
public class CoverSampleSettingCheckReq {
    private static final String ERROR_MSG = "不能为空";
    /**
     * 操作类型  草稿：DRAFT  完成：FINISH
     */
    @NotBlank(message = "操作类型" + ERROR_MSG)
    private String operationType;
    /**
     * 逻辑编码(工作台列表会返回)
     */
    @NotBlank(message = "逻辑编码" + ERROR_MSG)
    private String ppnuCode;
    /**
     * 项目编码
     */
    private String projectCode;
    /**
     * 审核意见
     */
    private String checkInfo;
    /**
     * 审核文件  多个英文分号隔开
     */
    private String checkFile;
    /**
     * 下一节点编码
     */
    private String nextNodeCode;
    /**
     * 被指派人编码集合
     */
    private List<String> userCodeList;
    /**
     * 悬赏系数
     */
    private BigDecimal rewardCoefficient;
    /**
     * 任务限时
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date taskTimeLimit;
}
