package com.ella.entity.operation.dto.proofreadNodeOperation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: wqq
 * @Date: 2021/6/1 15:17
 * @Description:
 * @Modified:
 */
@Data
public class EditBeforeBookDetailListDto {
    /**
     * 图书类型
     */
    private String bookType;
    /**
     * 逻辑主键编码
     */
    private String baseBookCode;
    /**
     * 图书页数
     */
    private Integer pageNum;

    /**
     * 节点指派人
     */
    private List<String> userCodeList;

    /**
     * 悬赏系数
     */
    private BigDecimal rewardCoefficient;
    /**
     * 任务限时
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date taskTimeLimit;
}
