package com.ella.entity.operation.dto.project;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: wqq
 * @Date: 2021/5/14 15:59
 * @Description:
 * @Modified:
 */
@Data
public class BookListDto {
    /**
     * 定价
     */
    private BigDecimal bookPrice;
    /**
     * book类型，关联es_enum的enum_code，且type=BOOK
     */
    private String bookType;
    /**
     * 平均印张
     */
    private BigDecimal avgStampNum;
    /**
     * 印张
     */
    private BigDecimal stampNum;
    /**
     *开本，关联es_enum的enum_code，且type=FORMAT
     */
    private String formatCode;
    /**
     *装订方式，关联es_enum的enum_code，且type=BINDING
     */
    private String bindingCode;
    /**
     *颜色，关联es_enum的enum_code，且type=COLOR
     */
    private String colorCode;
    /**
     *克重，关联es_enum的enum_code，且type=WEIGHT
     */
    private String weightCode;
    /**
     *纸张类别，关联es_enum的enum_code，且type=PAGE_TYPE
     */
    private String pageTypeCode;
    /**
     *年级，关联es_enum的enum_code，且type=GRADE
     */
    private String gradeCode;
    /**
     *学科，关联es_enum的enum_code，且type=SUBJECT
     */
    private String subject;
    /**
     *册别，关联es_enum的enum_code，且type=VOLUME
     */
    private String volumeCode;
    /**
     *版本，关联es_enum的enum_code，且type=VERSION
     */
    private String versionCode;
    /**
     * 学用/教用，关联es_enum的enum_code，且type=USE
     */
    private String useCode;
    /**
     *地区，关联es_enum的enum_code，且type=AREA
     */
    private String areaCode;
    /**
     *地区名字
     */
    private String areaName;
    /**
     *开始年度
     */
    private String startYear;
    /**
     *结束年度
     */
    private String endYear;
    /**
     *学期，关联es_enum的enum_code，且type=SEMESTER
     */
    private String semesterCode;
    /**
     *阶段，关联es_enum的enum_code，且type=STAGE
     */
    private String stageCode;
    /**
     *性质，关联es_enum的enum_code，且type=NATURE
     */
    private String natureCode;
    /**
     * 图书编码
     */
    private String bookCode;
    /**
     * 图书名称
     */
    private String bookName;
    /**
     * 三审意见单
     */
    private String thirdCheckForm;
}
