package com.ella.entity.operation.dto.project;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: wqq
 * @Date: 2021/5/14 15:10
 * @Description:
 * @Modified:
 */
@Data
public class BookInformationDto {
    /**
     * 图书信息编码(后端自己设置)
     */
    private String pbiCode;
    /**
     * 项目编码(后端自己设置)
     */
    private String projectCode;
    /**
     * 图书结构 关联es_enum的enum_code，且type=BOOK
     */
    private String bookType;
    /**
     * 平均印张
     */
    private BigDecimal avgStampNum;
    /**
     * 开本，关联es_enum的enum_code，且type=FORMAT
     */
    private String formatCode;
    /**
     * 装订方式，关联es_enum的enum_code，且type=BINDING
     */
    private String bindingCode;
    /**
     * 颜色，关联es_enum的enum_code，且type=COLOR
     */
    private String colorCode;
    /**
     * 克重，关联es_enum的enum_code，且type=WEIGHT
     */
    private String weightCode;
    /**
     * 纸张类别，关联es_enum的enum_code，且type=PAGE_TYPE
     */
    private String pageTypeCode;
}
