package com.ella.entity.operation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ProjectProcessNodeFromUserRef {
    private Integer id;

    private String ppnuCode;

    private String ppCode;

    private String isTaskAllocation;

    private Integer finishWay;

    private String remark;

    private String nodeCode;

    private String fromUserCode;

    private String type;

    private String isFirstNode;

    private String status;

    private String disabled;

    private Date modifyTime;
    /**
     * 悬赏系数
     */
    private BigDecimal rewardCoefficient;
    /**
     * 任务限时
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date taskTimeLimit;
    /**
     * 该任务是否已读(只针对悬赏任务弹窗) 已读 YES 未读 NO
     */
    private String isWhetherRead;
}