package com.ella.entity.operation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class BookProcessNodeFromUserRef {
    private Integer id;

    private String bpnuCode;

    private String bookCode;

    private String bookType;

    private String baseBookCode;

    private String pageNum;

    private String ppCode;

    private String nodeCode;

    private String fromUserCode;

    private String isFirstNode;

    private String isTaskAllocation;

    private Integer finishWay;

    private String remark;

    private String processNodeType;

    private String status;

    private String disabled;

    private Date createTime;

    private Date modifyTime;

    private BigDecimal rewardCoefficient;

    @JsonFormat(pattern = "yyyy-MM-dd HH", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    private Date taskTimeLimit;

    private String isWhetherRead="YES";
}