package com.ella.entity.composition.vo;

import com.ella.entity.PageParam;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

import static com.ella.constant.Constant.ERROR_MSG;

/**
 * @author ：xixiaoyi
 * @date ：Created by 2021/5/21
 * @modified By：
 */
@Data
public class ParentFormatPageVo extends PageParam {
    private String pfsPageCode;
    @NotBlank(message = "项目编号" + ERROR_MSG)
    private String pfsPageName;
    private String parentFormatSetCode;
    @NotBlank(message = "页类型" + ERROR_MSG)
    private String pageType;
    @NotBlank(message = "左右版面设置" + ERROR_MSG)
    private String formatType;
    private String formatSetPageJson;
    @NotBlank(message = "母版页JSON文件地址" + ERROR_MSG)
    private String formatSetPageJsonUrl;
    @NotBlank(message = "母版页JSON文件MD5" + ERROR_MSG)
    private String md5;
    @Valid
    @NotNull(message = "母版对应页书眉" + ERROR_MSG)
    private List<ParentFormatPageEyebrowVo> pageEyebrowList;
    private List<ParentFormatPageNumVo> pageNumList;

}
