package com.ella.entity.composition.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import java.util.List;

/**
 * @author ：xixiaoyi
 * @date ：Created by 2021/5/21
 * @modified By：
 */
@Data
public class PageFileVo {
    private static final String ERROR_MSG = "不能为空";
    @NotBlank(message = "图书页或母版编号" + ERROR_MSG)
    private String pageCode;
    @NotBlank(message = "类型" + ERROR_MSG)
    private String pageType;
    @Valid
    @NotEmpty(message = "文件列表" + ERROR_MSG)
    private List<FileVo> fileList;

}