package com.ella.constraint.inf.impl;


import javax.validation.ConstraintViolation;

import com.ella.constraint.annotation.DefaultLength;
import com.ella.constraint.annotation.DefaultURL;
import com.ella.constraint.inf.SetDefault;

/**
 * Set default {@link String} value for {@Code field} annotated by {@link DefaultLength}
 */
public class SetValidURLDefault implements SetDefault<DefaultURL, String> {

    @Override
    public <B> void setDefault(ConstraintViolation<B> tConstraintViolation, DefaultURL annotation) throws Exception {
        String value = annotation.value();
        invokeSetFieldValue(tConstraintViolation, value);
    }

    @Override
    public Class<DefaultURL> getAnnotation() {
        return DefaultURL.class;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }


}
