package com.ella.constraint.inf.impl;

import javax.validation.ConstraintViolation;

import com.ella.constraint.annotation.DefaultString;
import com.ella.constraint.inf.SetDefault;

/**
 * Set default {@link String} value for {@Code field} annotated by {@link DefaultString}
 */
public class SetDefaultString implements SetDefault<DefaultString, String> {

    @Override
    public <B> void setDefault(ConstraintViolation<B> tConstraintViolation, DefaultString annotation) throws Exception {
        String value = annotation.value();
        invokeSetFieldValue(tConstraintViolation, value);
    }

    @Override
    public Class<DefaultString> getAnnotation() {
        return DefaultString.class;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }
}
