package com.ella.constraint.inf.impl;


import org.apache.commons.lang3.StringUtils;

import com.ella.constraint.annotation.DefaultDate;
import com.ella.constraint.inf.SetDefault;

import javax.validation.ConstraintViolation;
import javax.xml.crypto.Data;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Set default {@link Date} value for {@Code field} annotated by {@link DefaultDate}
 */
public class SetDefaultDate implements SetDefault<DefaultDate, Date> {

    @Override
    public <B> void setDefault(ConstraintViolation<B> tConstraintViolation, DefaultDate annotation) throws Exception {
        SimpleDateFormat dateFormat = null;
        String format = annotation.format().trim();
        String value = annotation.value().trim();
        Date date = invokeGetFieldValue(tConstraintViolation);//获取被注解属性的值
        //是否格式化
        if (StringUtils.isNotBlank(format)) dateFormat = new SimpleDateFormat(format);
        //是否已设定了日期
        if (dateFormat != null && StringUtils.isNotBlank(value))date = dateFormat.parse(value);
        //如果日期时间为空设置为当前时间
        if (date == null) date = new Date();

        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        setDateTime(annotation, cl);//修改日期指定的字段值
        addDateTime(annotation, cl);//对日期指定的字段值进行加减操作
        setTimeZone(annotation, cl);//指定时区
        if (dateFormat != null) dateFormat.parse(dateFormat.format(cl.getTime()));//按照指定的格式格式化日期
        invokeSetFieldValue(tConstraintViolation, cl.getTime());
    }

    @Override
    public Class<DefaultDate> getAnnotation() {
        return DefaultDate.class;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }

    private void setTimeZone(DefaultDate annotation, Calendar cl) {
        if (annotation.ZONE_OFFSET() > 0) cl.add(Calendar.ZONE_OFFSET, annotation.ZONE_OFFSET());
    }

    private void addDateTime(DefaultDate annotation, Calendar cl) {
        if (annotation.ADD_YEAR() != 0) cl.add(Calendar.YEAR, annotation.ADD_YEAR());
        if (annotation.ADD_MONTH() != 0) cl.add(Calendar.MONTH, annotation.ADD_MONTH());
        if (annotation.ADD_WEEK_OF_MONTH() != 0) cl.add(Calendar.WEEK_OF_MONTH, annotation.ADD_WEEK_OF_MONTH());
        if (annotation.ADD_WEEK_OF_YEAR() != 0) cl.add(Calendar.WEEK_OF_YEAR, annotation.ADD_WEEK_OF_YEAR());
        if (annotation.ADD_DATE() != 0) cl.add(Calendar.DATE, annotation.ADD_DATE());
        if (annotation.ADD_DAY_OF_WEEK() != 0) cl.add(Calendar.MONTH, annotation.ADD_MONTH());
        if (annotation.ADD_DAY_OF_WEEK_IN_MONTH() != 0) cl.add(Calendar.DAY_OF_WEEK_IN_MONTH, annotation.ADD_DAY_OF_WEEK_IN_MONTH());
        if (annotation.ADD_DAY_OF_MONTH() != 0) cl.add(Calendar.DAY_OF_MONTH, annotation.ADD_DAY_OF_MONTH());
        if (annotation.ADD_DAY_OF_YEAR() != 0) cl.add(Calendar.DAY_OF_YEAR, annotation.ADD_DAY_OF_WEEK());
        if (annotation.ADD_HOUR() != 0) cl.add(Calendar.HOUR, annotation.ADD_HOUR());
        if (annotation.ADD_HOUR_OF_DAY() != 0) cl.add(Calendar.HOUR_OF_DAY, annotation.ADD_HOUR_OF_DAY());
        if (annotation.ADD_MINUTE() != 0) cl.add(Calendar.MINUTE, annotation.MINUTE());
        if (annotation.ADD_SECOND() != 0) cl.add(Calendar.SECOND, annotation.ADD_SECOND());
        if (annotation.ADD_MILLISECOND() != 0) cl.add(Calendar.MILLISECOND, annotation.ADD_MILLISECOND());
    }

    private void setDateTime(DefaultDate annotation, Calendar cl) {
        if (annotation.YEAR() > 0) cl.set(Calendar.YEAR, annotation.YEAR());
        if (annotation.MONTH() > 0) cl.set(Calendar.MONTH, annotation.MONTH());
        if (annotation.WEEK_OF_MONTH() > 0) cl.set(Calendar.WEEK_OF_MONTH, annotation.WEEK_OF_MONTH());
        if (annotation.WEEK_OF_YEAR() > 0) cl.set(Calendar.WEEK_OF_YEAR, annotation.WEEK_OF_YEAR());
        if (annotation.DATE() > 0) cl.set(Calendar.DATE, annotation.DATE());
        if (annotation.DAY_OF_MONTH() > 0) cl.set(Calendar.DAY_OF_MONTH, annotation.DAY_OF_MONTH());
        if (annotation.DAY_OF_WEEK() > 0) cl.set(Calendar.DAY_OF_WEEK, annotation.DAY_OF_WEEK());
        if (annotation.DAY_OF_WEEK_IN_MONTH() > 0)cl.set(Calendar.DAY_OF_WEEK_IN_MONTH, annotation.DAY_OF_WEEK_IN_MONTH());
        if (annotation.DAY_OF_YEAR() > 0) cl.set(Calendar.DAY_OF_YEAR, annotation.DAY_OF_YEAR());
        if (annotation.HOUR() > 0) cl.set(Calendar.HOUR, annotation.HOUR());
        if (annotation.HOUR_OF_DAY() > 0) cl.set(Calendar.HOUR_OF_DAY, annotation.HOUR_OF_DAY());
        if (annotation.SECOND() > 0) cl.set(Calendar.SECOND, annotation.SECOND());
        if (annotation.MINUTE() > 0) cl.set(Calendar.MINUTE, annotation.MINUTE());
        if (annotation.MILLISECOND() > 0) cl.set(Calendar.MILLISECOND, annotation.MILLISECOND());
    }

}
