package com.ella.constraint.inf;


import java.util.HashMap;
import java.util.Map;

import com.ella.constraint.annotation.*;
import com.ella.constraint.inf.impl.*;


/**
 * Parameter validation sets the default value of the container
 *
 * @author mc
 */
public class SetDefaultContainer {
    private final static Map<String, SetDefault> container;

    static {
        container = new HashMap<>();
        try {
            /*for (Class<?> c : ClassUtil.getAllAssignedClass(SetDefault.class)) {
                SetDefault setDefault = (SetDefault) c.newInstance();
                SetDefaultContainer.getInstance().add(setDefault.getAnnotation().getName(), setDefault);
            }*/
            container.put(DefaultString.class.getName(), new SetDefaultString());
            container.put(DefaultDate.class.getName(), new SetDefaultDate());
            container.put(DefaultLength.class.getName(), new SetValidLengthDefault());
            container.put(DefaultCode.class.getName(), new SetDefaultCode());
            container.put(DefaultURL.class.getName(), new SetValidURLDefault());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class RequestCommandContainerHolder {
        private static SetDefaultContainer instance = new SetDefaultContainer();
    }

    public static SetDefaultContainer getInstance() {
        return RequestCommandContainerHolder.instance;
    }

    public void add(String type, SetDefault command) {
        container.put(type, command);
    }

    public SetDefault get(String type) {
        return container.get(type);
    }
}
