/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat, Inc. and/or its affiliates, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ella.constraint.annotation;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.ella.constraint.validation.DefaultDateValidator;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Calendar;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * The annotated element must be not {@code null}.
 * Accepts any type.
 *
 * @author mc
 */
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Retention(RUNTIME)
@Documented
@Constraint(validatedBy = {DefaultDateValidator.class})
public @interface DefaultDate {
    /**
     * Set the value of the YEAR directly
     *
     * @return
     */
    int YEAR() default -1;

    /**
     * Set the value of the MONTH directly
     *
     * @return
     */
    int MONTH() default -1;

    /**
     * Set the value of the DATE directly
     *
     * @return
     */
    int DATE() default -1;

    /**
     * Set the value of the DAY_OF_WEEK directly
     *
     * @return
     */
    int DAY_OF_WEEK() default -1;

    /**
     * Set the value of the DAY_OF_MONTH directly
     *
     * @return
     */
    int DAY_OF_MONTH() default -1;

    /**
     * Set the value of the DAY_OF_WEEK_IN_MONTH directly
     *
     * @return
     */
    int DAY_OF_WEEK_IN_MONTH() default -1;

    /**
     * Set the value of the DAY_OF_YEAR directly
     *
     * @return
     */
    int DAY_OF_YEAR() default -1;

    /**
     * Set the value of the WEEK_OF_YEAR directly
     *
     * @return
     */
    int WEEK_OF_YEAR() default -1;

    /**
     * Set the value of the WEEK_OF_MONTH directly
     *
     * @return
     */
    int WEEK_OF_MONTH() default -1;

    /**
     * Set the value of the HOUR directly
     *
     * @return
     */
    int HOUR() default -1;

    /**
     * Set the value of the HOUR_OF_DAY directly
     *
     * @return
     */
    int HOUR_OF_DAY() default -1;

    /**
     * Set the value of the MINUTE directly
     *
     * @return
     */
    int MINUTE() default -1;

    /**
     * Set the value of the SECOND directly
     *
     * @return
     */
    int SECOND() default -1;

    /**
     * Set the value of the MILLISECOND directly
     *
     * @return
     */
    int MILLISECOND() default -1;

    /**
     * Adds or subtracts the specified amount of YEAR
     *
     * @return
     */
    int ADD_YEAR() default 0;

    /**
     * Adds or subtracts the specified amount of MONTH
     *
     * @return
     */
    int ADD_MONTH() default 0;

    /**
     * Adds or subtracts the specified amount of WEEK_OF_MONTH
     *
     * @return
     */
    int ADD_WEEK_OF_MONTH() default 0;

    /**
     * Adds or subtracts the specified amount of WEEK_OF_YEAR
     *
     * @return
     */
    int ADD_WEEK_OF_YEAR() default 0;

    /**
     * Adds or subtracts the specified amount of DATE
     *
     * @return
     */
    int ADD_DATE() default 0;

    /**
     * Adds or subtracts the specified amount of DAY_OF_WEEK
     *
     * @return
     */
    int ADD_DAY_OF_WEEK() default 0;

    /**
     * Adds or subtracts the specified amount of DAY_OF_WEEK_IN_MONTH
     *
     * @return
     */
    int ADD_DAY_OF_WEEK_IN_MONTH() default 0;

    /**
     * Adds or subtracts the specified amount of DAY_OF_MONTH
     *
     * @return
     */
    int ADD_DAY_OF_MONTH() default 0;

    /**
     * Adds or subtracts the specified amount of DAY_OF_YEAR
     *
     * @return
     */
    int ADD_DAY_OF_YEAR() default 0;

    /**
     * Adds or subtracts the specified amount of HOUR
     *
     * @return
     */
    int ADD_HOUR() default 0;

    /**
     * Adds or subtracts the specified amount of HOUR_OF_DAY
     *
     * @return
     */
    int ADD_HOUR_OF_DAY() default 0;

    /**
     * Adds or subtracts the specified amount of SECOND
     *
     * @return
     */
    int ADD_SECOND() default 0;

    /**
     * Adds or subtracts the specified amount of MINUTE
     *
     * @return
     */
    int ADD_MINUTE() default 0;

    /**
     * Adds or subtracts the specified amount of millisecond
     *
     * @return
     */
    int ADD_MILLISECOND() default 0;

    /**
     * Set the value of the ZONE_OFFSET directly
     *
     * @return
     */
    int ZONE_OFFSET() default 0;

    String value() default "";

    String format() default "";

    String message() default "{javax.validation.constraints.NotNull.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    /**
     * Defines several {@link DefaultDate} annotations on the same element.
     *
     * @see DefaultDate
     */
    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
    @Retention(RUNTIME)
    @Documented
    @interface List {
        DefaultDate[] value();
    }
}

