package com.ella.constant;

/**
 * @author: wqq
 * @Date: 2021/4/21 10:47
 * @Description:
 * @Modified:
 */
public class Constant {
    /**
     * 公共常量
     */
    public static final String ADD = "ADD";
    public static final String EDIT = "EDIT";
    public static final String COPY = "COPY";
    public static final String DELETE = "DELETE";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String ON = "ON";
    public static final String OFF = "OFF";
    public static final String DRAFT = "DRAFT";
    public static final String FINISH = "FINISH";
    public static final String BOOK = "BOOK";
    public static final Integer ZERO = 0;
    public static final Integer ONE = 1;
    public static final Integer TWO = 2;
    public static final Integer THREE = 3;
    public static final Integer FOUR = 4;
    public static final Integer TEN = 10;
    public static final String WAITING = "WAITING";
    public static final String WAITING_ACTIVATE = "WAITING_ACTIVATE";
    public static final String WAITING_CLAIM = "WAITING_CLAIM";
    public static final String FINISHED = "FINISHED";
    public static final String DOING = "DOING";
    public static final String TO_FINISH = "TO_FINISH";
    public static final String CHECKED = "CHECKED";
    public static final String EDIT_BEFORE_DEFEND = "EDIT_BEFORE_DEFEND";
    public static final String EDIT_BEFORE = "EDIT_BEFORE";
    public static final String NO = "NO";
    public static final String YES = "YES";
    public static final String SUSPEND = "SUSPEND";
    public static final String RETURN = "RETURNED";
    public static final String JUMP = "JUMPED";
    public static final String separatorStr = ",";
    public static final String NULL = "null";
    public static final String ERROR_MSG = "不能为空";
    public static final String STR_VALUE_TYPE="STRING";
    public static final String ENUM_SEPARATOR="_";
    /**
     * 默认系统编码
     */
    public static final String default_sys_code = "S2021041617230001";
    /**
     * 朝霞运营工具用户登录token存放位置
     */
    public static final String SUNRISE_OPERATION_USER_LOGIN_TOKEN = "SUNRISE:OPERATION:USER:LOGIN:TOKEN:";
    /**
     * 朝霞运营工具用户登录token有限期7天
     */
    public static final long SUNRISE_OPERATION_USER_LOGIN_TOKEN_EXPIRE = 60 * 60 * 24 * 7;
    /**
     * 朝霞运营工具用户密码错误有限期5小时
     */
    public static final long SUNRISE_OPERATION_USER_PASSWORD_ERROR_EXPIRE = 60 * 60 * 5;

    /**
     * 朝霞运营工具用户密码错误redis存放位置
     */
    public static final String SUNRISE_OPERATION_USER_PASSWORD_ERROR_ADDRESS = "SUNRISE:OPERATION:USER:PASSWORD:ERROR:ADDRESS";
    /**
     * 朝霞运营工具用户忘记密码验证码存放位置
     */
    public static final String SUNRISE_OPERATION_FORGET_PASSWORD_CODE = "SUNRISE:OPERATION:USER:FORGET:PASSWORD:CODE:";
    /**
     * 朝霞运营工具用户更换手机号存放位置
     */
    public static final String SUNRISE_OPERATION_REPLACE_PHONE_CODE = "SUNRISE:OPERATION:USER:REPLACE:PHONE:CODE:";
    /**
     * 朝霞运营工具用户验证码有效期
     */
    public static final long SUNRISE_OPERATION_USER_CODE_EXPIRE = 5 * 60;

    /**
     * 朝霞短信发送类型(忘记密码)
     */
    public static final String SEND_TYPE_FORGET_PASSWORD = "FORGET-PASSWORD";

    /**
     * 朝霞短信发送类型(更换手机号)
     */
    public static final String SEND_TYPE_REPLACE_PHONE = "REPLACE-PHONE";
    /**
     * excel导入成功编码
     */
    public static final int EXCEL_SUCCESS_CODE = 200;
    /**
     * excel导入限制500条
     */
    public static final int IMPORT_EXCEL_LIMIT_NUM = 500;
    /**
     * 用户名、工号限制长度20
     */
    public static final int USER_NAME_ACCOUNT_LENGTH_LIMIT = 20;
    /**
     * 11位手机号正则表达式
     */
    public static final String PHONE_NUMBER_REG = "^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[89])\\d{8}$";
    /**
     * 流程状态-草稿
     */
    public static final String PROCESS_STATUS_DRAFT = "DRAFT";
    /**
     * 流程状态-待使用
     */
    public static final String PROCESS_STATUS_WAIT = "WAIT";

    /**
     * 流程状态-使用中
     */
    public static final String PROCESS_STATUS_USED = "USED";

    /**
     * 流程状态-停用
     */
    public static final String PROCESS_STATUS_STOP = "STOP";

    /**
     * 流程类型-创建项目
     */
    public static final String PROCESS_TYPE_CREATE_PROJECT = "CREATE_PROJECT";

    /**
     * 项目流程类型-编排校
     */
    public static final String PROJECT_PROCESS_TYPE_PROOFREAD = "PROOFREAD";

    /**
     * 项目流程类型-装帧设计
     */
    public static final String PROJECT_PROCESS_TYPE_GRAPHIC_DESIGN = "GRAPHIC_DESIGN";

    /**
     * 项目流程类型-项目审核
     */
    public static final String PROJECT_PROCESS_TYPE_PROJECT_CHECK = "PROJECT_CHECK";
    /**
     * 项目流程类型-项目创建
     */
    public static final String PROJECT_PROCESS_TYPE_PROJECT_CREATE = "PROJECT_CREATE";
    /**
     * 项目审核类型-项目审核
     */
    public static final String PROJECT_CHECK_TYPE_PROJECT = "PROJECT";
    /**
     * 项目审核类型-样张审核
     */
    public static final String PROJECT_CHECK_TYPE_SAMPLE = "SAMPLE";
    /**
     * 项目审核类型-封面样张审核
     */
    public static final String PROJECT_CHECK_TYPE_COVER_SAMPLE = "COVER_SAMPLE";
    /**
     * 流程记录操作类型-完成
     */
    public static final String PROCESS_HISTORY_OPERATION_TYPE_FINISH = "FINISH";
    /**
     * 流程记录操作类型-认领
     */
    public static final String PROCESS_HISTORY_OPERATION_TYPE_CLAIM = "CLAIM";
    /**
     * 流程记录操作类型-退回
     */
    public static final String PROCESS_HISTORY_OPERATION_TYPE_RETURN = "RETURN";
    /**
     * 流程记录操作类型-拆分
     */
    public static final String PROCESS_HISTORY_OPERATION_TYPE_SPLIT = "SPLIT";
    /**
     * 流程记录操作类型-合并
     */
    public static final String PROCESS_HISTORY_OPERATION_TYPE_MERGE = "MERGE";

}
