package com.ella.aspect;

import com.ella.response.ResponseParams;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;

import com.ella.exception.EllaBookException;

public abstract class ExceptionAspect {
    private ResponseParams res = new ResponseParams();

    public abstract void exceptionPointcut();

    @Around("exceptionPointcut()")
    public Object Interceptor(ProceedingJoinPoint joinPoint) {
        try {
            return joinPoint.proceed(joinPoint.getArgs());
        } catch (EllaBookException e) {
            e.printStackTrace();
            return e.getResponseParams();
        }catch (Throwable e) {
            e.printStackTrace();
            return res.error("000000", "服务器异常");
        }
    }

}

